/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Reward;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.api.TeamLevelUpEvent;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamReward;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class TeamLevelUpListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;

    @EventHandler(ignoreCancelled=true)
    public void onTeamLevelUp(TeamLevelUpEvent<T, U> event) {
        for (IridiumUser member : this.iridiumTeams.getTeamManager().getTeamMembers(event.getTeam())) {
            Player player = member.getPlayer();
            if (player == null) {
                return;
            }
            player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().teamLevelUp.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix).replace("%level%", String.valueOf(((Team)event.getTeam()).getLevel()))));
        }
        if (event.isFirstTimeAsLevel() && event.getLevel() > 1) {
            if (!this.iridiumTeams.getConfiguration().giveLevelRewards) {
                return;
            }
            Reward reward = null;
            List entries = this.iridiumTeams.getConfiguration().levelRewards.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
            for (Map.Entry entry : entries) {
                if (event.getLevel() % (Integer)entry.getKey() != 0) continue;
                reward = (Reward)entry.getValue();
            }
            if (reward != null) {
                reward.item.lore = StringUtils.processMultiplePlaceholders(reward.item.lore, this.iridiumTeams.getTeamsPlaceholderBuilder().getPlaceholders(event.getTeam()));
                reward.item.displayName = StringUtils.processMultiplePlaceholders(reward.item.displayName, this.iridiumTeams.getTeamsPlaceholderBuilder().getPlaceholders(event.getTeam()));
                this.iridiumTeams.getTeamManager().addTeamReward(new TeamReward((Team)event.getTeam(), reward));
            }
        }
    }

    @Generated
    public TeamLevelUpListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

