/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.placeholders;

import com.iridium.iridiumskyblock.dependencies.annotations.Nullable;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.TeamManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Placeholders<T extends Team, U extends IridiumUser<T>> {
    private final IridiumTeams<T, U> iridiumTeams;

    public Placeholders(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }

    public List<Placeholder> getDefaultPlaceholders() {
        return this.iridiumTeams.getTeamsPlaceholderBuilder().getPlaceholders(Optional.empty());
    }

    public List<Placeholder> getPlaceholders(@Nullable Player player) {
        IridiumUser user = player == null ? null : (IridiumUser)this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        Optional team = user == null ? Optional.empty() : this.iridiumTeams.getTeamManager().getTeamViaID(user.getTeamID());
        Optional current = user == null ? Optional.empty() : this.iridiumTeams.getTeamManager().getTeamViaPlayerLocation(player);
        List<T> topValue = this.iridiumTeams.getTeamManager().getTeams(TeamManager.SortType.Value, true);
        List<T> topExperience = this.iridiumTeams.getTeamManager().getTeams(TeamManager.SortType.Experience, true);
        ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>();
        placeholders.addAll(this.iridiumTeams.getTeamsPlaceholderBuilder().getPlaceholders(team));
        placeholders.addAll(this.iridiumTeams.getUserPlaceholderBuilder().getPlaceholders(Optional.ofNullable(user)));
        for (Placeholder placeholder : this.iridiumTeams.getTeamsPlaceholderBuilder().getPlaceholders(current)) {
            placeholders.add(new Placeholder("current_" + this.formatPlaceholderKey(placeholder.getKey()), placeholder.getValue()));
        }
        for (int i = 1; i <= 20; ++i) {
            Optional value = topValue.size() >= i ? Optional.of((Team)topValue.get(i - 1)) : Optional.empty();
            Optional experience = topExperience.size() >= i ? Optional.of((Team)topExperience.get(i - 1)) : Optional.empty();
            for (Placeholder placeholder : this.iridiumTeams.getTeamsPlaceholderBuilder().getPlaceholders(value)) {
                placeholders.add(new Placeholder("top_value_" + i + "_" + this.formatPlaceholderKey(placeholder.getKey()), placeholder.getValue()));
            }
            for (Placeholder placeholder : this.iridiumTeams.getTeamsPlaceholderBuilder().getPlaceholders(experience)) {
                placeholders.add(new Placeholder("top_experience_" + i + "_" + this.formatPlaceholderKey(placeholder.getKey()), placeholder.getValue()));
            }
        }
        return placeholders;
    }

    private String formatPlaceholderKey(String key) {
        return key.replace("%", "");
    }
}

