/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db;

import com.iridium.iridiumskyblock.dependencies.ormlite.db.DatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.Db2DatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.DerbyClientServerDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.DerbyEmbeddedDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.GenericOdbcDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.H2DatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.HsqldbDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.MariaDbDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.MysqlDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.NetezzaDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.OracleDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.PostgresDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.SqlServerDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.SqlServerJtdsDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.SqliteDatabaseType;
import java.util.ArrayList;
import java.util.List;

public class DatabaseTypeUtils {
    private static List<DatabaseType> databaseTypes = new ArrayList<DatabaseType>();

    private DatabaseTypeUtils() {
    }

    public static DatabaseType createDatabaseType(String databaseUrl) {
        String dbTypePart = DatabaseTypeUtils.extractDbType(databaseUrl);
        for (DatabaseType databaseType : databaseTypes) {
            if (!databaseType.isDatabaseUrlThisType(databaseUrl, dbTypePart)) continue;
            return databaseType;
        }
        throw new IllegalArgumentException("Unknown database-type url part '" + dbTypePart + "' in: " + databaseUrl);
    }

    private static String extractDbType(String databaseUrl) {
        if (!databaseUrl.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Database URL was expected to start with jdbc: but was " + databaseUrl);
        }
        String[] urlParts = databaseUrl.split(":");
        if (urlParts.length < 2) {
            throw new IllegalArgumentException("Database URL was expected to be in the form: jdbc:db-type:... but was " + databaseUrl);
        }
        return urlParts[1];
    }

    static {
        databaseTypes.add(new Db2DatabaseType());
        databaseTypes.add(new DerbyClientServerDatabaseType());
        databaseTypes.add(new DerbyEmbeddedDatabaseType());
        databaseTypes.add(new GenericOdbcDatabaseType());
        databaseTypes.add(new H2DatabaseType());
        databaseTypes.add(new HsqldbDatabaseType());
        databaseTypes.add(new MysqlDatabaseType());
        databaseTypes.add(new MariaDbDatabaseType());
        databaseTypes.add(new NetezzaDatabaseType());
        databaseTypes.add(new OracleDatabaseType());
        databaseTypes.add(new PostgresDatabaseType());
        databaseTypes.add(new SqliteDatabaseType());
        databaseTypes.add(new SqlServerDatabaseType());
        databaseTypes.add(new SqlServerJtdsDatabaseType());
    }
}

