/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db;

import com.iridium.iridiumskyblock.dependencies.ormlite.db.BaseDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.BaseFieldConverter;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DataPersister;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.FieldConverter;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.FieldType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.SqlType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.converter.BooleanNumberFieldConverter;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.types.BooleanCharType;
import com.iridium.iridiumskyblock.dependencies.ormlite.misc.IOUtils;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.DatabaseResults;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;

public class DerbyEmbeddedDatabaseType
extends BaseDatabaseType {
    protected static final String DATABASE_URL_PORTION = "derby";
    private static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DATABASE_NAME = "Derby";

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        if (!DATABASE_URL_PORTION.equals(dbTypePart)) {
            return false;
        }
        String[] parts = url.split(":");
        return parts.length >= 3 && !parts[2].startsWith("//");
    }

    @Override
    protected String[] getDriverClassNames() {
        return new String[]{DRIVER_CLASS_NAME};
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataType, FieldType fieldType) {
        switch (dataType.getSqlType()) {
            case BOOLEAN: {
                return BooleanNumberFieldConverter.getSingleton();
            }
            case CHAR: {
                if (dataType instanceof BooleanCharType) {
                    return BooleanNumberFieldConverter.getSingleton();
                }
                return CharFieldConverter.getSingleton();
            }
            case SERIALIZABLE: {
                return SerializableFieldConverter.getSingleton();
            }
        }
        return super.getFieldConverter(dataType, fieldType);
    }

    @Override
    protected void appendLongStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG VARCHAR");
    }

    @Override
    public void appendOffsetValue(StringBuilder sb, long offset) {
        sb.append("OFFSET ").append(offset).append(" ROWS ");
    }

    @Override
    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendCharType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG VARCHAR FOR BIT DATA");
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("GENERATED BY DEFAULT AS IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('\"').append(name).append('\"');
    }

    @Override
    public boolean isLimitSqlSupported() {
        return false;
    }

    @Override
    public String getPingStatement() {
        return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return true;
    }

    @Override
    public boolean isAllowGeneratedIdInsertSupported() {
        return false;
    }

    @Override
    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("VALUES(DEFAULT)");
    }

    @Override
    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        super.appendSerializableType(sb, fieldType, fieldWidth);
    }

    private static class CharFieldConverter
    extends BaseFieldConverter {
        private static final CharFieldConverter singleTon = new CharFieldConverter();

        private CharFieldConverter() {
        }

        public static CharFieldConverter getSingleton() {
            return singleTon;
        }

        @Override
        public SqlType getSqlType() {
            return SqlType.INTEGER;
        }

        @Override
        public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
            char character = ((Character)javaObject).charValue();
            return (int)character;
        }

        @Override
        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            if (defaultStr.length() != 1) {
                throw new SQLException("Problems with field " + fieldType + ", default string to long: '" + defaultStr + "'");
            }
            return (int)defaultStr.charAt(0);
        }

        @Override
        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getInt(columnPos);
        }

        @Override
        public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
            int intVal = (Integer)sqlArg;
            return Character.valueOf((char)intVal);
        }

        @Override
        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
            return this.sqlArgToJava(fieldType, Integer.parseInt(stringValue), columnPos);
        }
    }

    private static class SerializableFieldConverter
    extends BaseFieldConverter {
        private static final SerializableFieldConverter singleTon = new SerializableFieldConverter();

        private SerializableFieldConverter() {
        }

        public static SerializableFieldConverter getSingleton() {
            return singleTon;
        }

        @Override
        public SqlType getSqlType() {
            return SqlType.BLOB;
        }

        @Override
        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            throw new SQLException("Default values for serializable types are not supported");
        }

        @Override
        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getBlobStream(columnPos);
        }

        @Override
        public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
            InputStream stream = (InputStream)sqlArg;
            try {
                ObjectInputStream objInStream = new ObjectInputStream(stream);
                Object object = objInStream.readObject();
                return object;
            }
            catch (Exception e) {
                throw new SQLException("Could not read serialized object from result blob", e);
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }

        @Override
        public Object javaToSqlArg(FieldType fieldType, Object javaObject) throws SQLException {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objOutStream = new ObjectOutputStream(outStream);
                objOutStream.writeObject(javaObject);
            }
            catch (Exception e) {
                throw new SQLException("Could not write serialized object to output stream", e);
            }
            return new SerialBlob(outStream.toByteArray());
        }

        @Override
        public boolean isStreamType() {
            return true;
        }

        @Override
        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) throws SQLException {
            throw new SQLException("Parsing string value for serializable types is not supported");
        }
    }
}

