/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db;

import com.iridium.iridiumskyblock.dependencies.ormlite.db.BaseDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.FieldType;
import java.util.List;

public class PostgresDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "postgresql";
    private static final String DRIVER_CLASS_NAME = "org.postgresql.Driver";
    private static final String DATABASE_NAME = "Postgres";

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    @Override
    protected String[] getDriverClassNames() {
        return new String[]{DRIVER_CLASS_NAME};
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    @Override
    protected void appendUuidNativeType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("UUID");
    }

    @Override
    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BYTEA");
    }

    @Override
    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BYTEA");
    }

    @Override
    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        String sequenceName = fieldType.getGeneratedIdSequence();
        StringBuilder seqSb = new StringBuilder(64);
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, sequenceName);
        statementsBefore.add(seqSb.toString());
        sb.append("DEFAULT NEXTVAL(");
        sb.append('\'').append('\"').append(sequenceName).append('\"').append('\'');
        sb.append(") ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        boolean first = true;
        for (String namePart : name.split("\\.")) {
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append('\"').append(namePart).append('\"');
        }
    }

    @Override
    public boolean isIdSequenceNeeded() {
        return true;
    }

    @Override
    public boolean isSelectSequenceBeforeInsert() {
        return true;
    }

    @Override
    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("SELECT NEXTVAL(");
        this.appendEscapedWord(sb, sequenceName);
        sb.append(')');
    }

    @Override
    public boolean isTruncateSupported() {
        return true;
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        int major = this.driver.getMajorVersion();
        if (major > 9 || major == 9 && this.driver.getMinorVersion() >= 1) {
            return true;
        }
        return super.isCreateIfNotExistsSupported();
    }

    @Override
    public boolean isSequenceNamesMustBeLowerCase() {
        return true;
    }
}

