/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.ormlite.stmt;

import com.iridium.iridiumskyblock.dependencies.ormlite.dao.CloseableIterator;
import com.iridium.iridiumskyblock.dependencies.ormlite.dao.Dao;
import com.iridium.iridiumskyblock.dependencies.ormlite.dao.ObjectCache;
import com.iridium.iridiumskyblock.dependencies.ormlite.logger.Logger;
import com.iridium.iridiumskyblock.dependencies.ormlite.logger.LoggerFactory;
import com.iridium.iridiumskyblock.dependencies.ormlite.misc.IOUtils;
import com.iridium.iridiumskyblock.dependencies.ormlite.stmt.GenericRowMapper;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.CompiledStatement;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.ConnectionSource;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.DatabaseConnection;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.DatabaseResults;
import java.sql.SQLException;

public class SelectIterator<T, ID>
implements CloseableIterator<T> {
    private static final Logger logger = LoggerFactory.getLogger(SelectIterator.class);
    private final Class<?> dataClass;
    private final Dao<T, ID> classDao;
    private final ConnectionSource connectionSource;
    private final DatabaseConnection connection;
    private final CompiledStatement compiledStmt;
    private final DatabaseResults results;
    private final GenericRowMapper<T> rowMapper;
    private boolean first = true;
    private boolean closed;
    private boolean alreadyMoved;
    private T last;
    private int rowC;

    public SelectIterator(Class<?> dataClass, Dao<T, ID> classDao, GenericRowMapper<T> rowMapper, ConnectionSource connectionSource, DatabaseConnection connection, CompiledStatement compiledStmt, ObjectCache objectCache) throws SQLException {
        this.dataClass = dataClass;
        this.classDao = classDao;
        this.rowMapper = rowMapper;
        this.connectionSource = connectionSource;
        this.connection = connection;
        this.compiledStmt = compiledStmt;
        this.results = compiledStmt.runQuery(objectCache);
        logger.debug("starting iterator @{} for '{}'", this.hashCode(), (Object)compiledStmt);
    }

    public boolean hasNextThrow() throws SQLException {
        boolean result;
        if (this.closed) {
            return false;
        }
        if (this.alreadyMoved) {
            return true;
        }
        if (this.first) {
            this.first = false;
            result = this.results.first();
        } else {
            result = this.results.next();
        }
        if (!result) {
            IOUtils.closeThrowSqlException(this, "iterator");
        }
        this.alreadyMoved = true;
        return result;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextThrow();
        }
        catch (SQLException e) {
            this.last = null;
            this.closeQuietly();
            throw new IllegalStateException("Errors getting more results of " + this.dataClass, e);
        }
    }

    @Override
    public T first() throws SQLException {
        if (this.closed) {
            return null;
        }
        this.first = false;
        if (this.results.first()) {
            return this.getCurrent();
        }
        return null;
    }

    @Override
    public T previous() throws SQLException {
        if (this.closed) {
            return null;
        }
        this.first = false;
        if (this.results.previous()) {
            return this.getCurrent();
        }
        return null;
    }

    @Override
    public T current() throws SQLException {
        if (this.closed) {
            return null;
        }
        if (this.first) {
            return this.first();
        }
        return this.getCurrent();
    }

    @Override
    public T nextThrow() throws SQLException {
        if (this.closed) {
            return null;
        }
        if (!this.alreadyMoved) {
            boolean hasResult;
            if (this.first) {
                this.first = false;
                hasResult = this.results.first();
            } else {
                hasResult = this.results.next();
            }
            if (!hasResult) {
                this.first = false;
                return null;
            }
        }
        this.first = false;
        return this.getCurrent();
    }

    @Override
    public T next() {
        SQLException sqlException = null;
        try {
            T result = this.nextThrow();
            if (result != null) {
                return result;
            }
        }
        catch (SQLException e) {
            sqlException = e;
        }
        this.last = null;
        this.closeQuietly();
        throw new IllegalStateException("Could not get next result for " + this.dataClass, sqlException);
    }

    @Override
    public T moveRelative(int offset) throws SQLException {
        if (this.closed) {
            return null;
        }
        this.first = false;
        if (this.results.moveRelative(offset)) {
            return this.getCurrent();
        }
        return null;
    }

    @Override
    public T moveAbsolute(int position) throws SQLException {
        if (this.closed) {
            return null;
        }
        this.first = false;
        if (this.results.moveAbsolute(position)) {
            return this.getCurrent();
        }
        return null;
    }

    public void removeThrow() throws SQLException {
        if (this.last == null) {
            throw new IllegalStateException("No last " + this.dataClass + " object to remove. Must be called after a call to next.");
        }
        if (this.classDao == null) {
            throw new IllegalStateException("Cannot remove " + this.dataClass + " object because classDao not initialized");
        }
        try {
            this.classDao.delete(this.last);
        }
        finally {
            this.last = null;
        }
    }

    @Override
    public void remove() {
        try {
            this.removeThrow();
        }
        catch (SQLException e) {
            this.closeQuietly();
            throw new IllegalStateException("Could not delete " + this.dataClass + " object " + this.last, e);
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.compiledStmt.close();
            this.closed = true;
            this.last = null;
            logger.debug("closed iterator @{} after {} rows", this.hashCode(), (Object)this.rowC);
            try {
                this.connectionSource.releaseConnection(this.connection);
            }
            catch (SQLException e) {
                throw new SQLException("could not release connection", e);
            }
        }
    }

    @Override
    public void closeQuietly() {
        IOUtils.closeQuietly(this);
    }

    @Override
    public DatabaseResults getRawResults() {
        return this.results;
    }

    @Override
    public void moveToNext() {
        this.last = null;
        this.first = false;
        this.alreadyMoved = false;
    }

    private T getCurrent() throws SQLException {
        this.last = this.rowMapper.mapRow(this.results);
        this.alreadyMoved = false;
        ++this.rowC;
        return this.last;
    }
}

