/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.xseries.base;

import com.iridium.iridiumskyblock.dependencies.annotations.ApiStatus;
import com.iridium.iridiumskyblock.dependencies.annotations.Contract;
import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.annotations.Nullable;
import com.iridium.iridiumskyblock.dependencies.xseries.base.XModuleMetadata;
import com.iridium.iridiumskyblock.dependencies.xseries.base.XRegistry;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public interface XBase<XForm extends XBase<XForm, BukkitForm>, BukkitForm> {
    @NotNull
    @Contract(pure=true)
    public String name();

    @ApiStatus.Internal
    @Contract(pure=true)
    public String[] getNames();

    @NotNull
    @Contract(pure=true)
    default public String friendlyName() {
        return Arrays.stream(this.name().split("_")).map(t -> t.charAt(0) + t.substring(1).toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(" "));
    }

    @Nullable
    @Contract(pure=true)
    public BukkitForm get();

    @Contract(pure=true)
    default public boolean isSupported() {
        return this.get() != null;
    }

    @NotNull
    @Contract(pure=true)
    default public XForm or(XForm other) {
        return (XForm)(this.isSupported() ? this : other);
    }

    @ApiStatus.Internal
    default public XModuleMetadata getMetadata() {
        XRegistry registry = XRegistry.registryOf(this.getClass());
        return registry.getOrRegisterMetadata(this, registry.getBackingField(this), false);
    }
}

