/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.gui;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.configs.Biomes;
import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.NoItemGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BiomeCategoryGUI
extends BackGUI {
    private final String categoryName;
    private final Biomes.BiomeCategory biomeCategory;
    private int page;

    public BiomeCategoryGUI(String categoryName, Player player) {
        super(IridiumSkyblock.getInstance().getInventories().biomeCategoryGUI.background, player, IridiumSkyblock.getInstance().getInventories().backButton);
        this.categoryName = categoryName;
        this.biomeCategory = IridiumSkyblock.getInstance().getBiomes().categories.get(categoryName);
        this.page = 1;
    }

    @NotNull
    public Inventory getInventory() {
        NoItemGUI biomeCategoryGUI = IridiumSkyblock.getInstance().getInventories().biomeCategoryGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.biomeCategory.inventorySize, (String)StringUtils.color(biomeCategoryGUI.title.replace("%biome_category_name%", this.categoryName)));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        if (!IridiumSkyblock.getInstance().getBiomes().items.containsKey(this.categoryName)) {
            IridiumSkyblock.getInstance().getLogger().warning("Biome Category " + this.categoryName + " Is not configured with any items!");
            return;
        }
        for (Biomes.BiomeItem biomeItem : IridiumSkyblock.getInstance().getBiomes().items.get(this.categoryName)) {
            if (biomeItem.page != this.page) continue;
            ItemStack itemStack = biomeItem.type.parseItem();
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemStack.setAmount(biomeItem.defaultAmount);
            itemMeta.setDisplayName(StringUtils.color(biomeItem.name));
            itemMeta.setLore(this.getBiomeLore(biomeItem));
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(biomeItem.slot, itemStack);
        }
        if (this.isPaged()) {
            inventory.setItem(inventory.getSize() - 3, ItemStackUtils.makeItem(IridiumSkyblock.getInstance().getInventories().nextPage));
            inventory.setItem(inventory.getSize() - 7, ItemStackUtils.makeItem(IridiumSkyblock.getInstance().getInventories().previousPage));
        }
    }

    public List<Integer> getPages() {
        return IridiumSkyblock.getInstance().getBiomes().items.get(this.categoryName).stream().map(value -> value.page).distinct().collect(Collectors.toList());
    }

    public boolean isPaged() {
        return this.getPages().size() > 1;
    }

    public boolean canNextPage() {
        return this.getPages().contains(this.page + 1);
    }

    public boolean canPreviousPage() {
        return this.page > 1;
    }

    private List<Placeholder> getBiomeLorePlaceholders(Biomes.BiomeItem item) {
        ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>(Arrays.asList(new Placeholder("minLevel", String.valueOf(item.minLevel)), new Placeholder("vault_cost", IridiumSkyblock.getInstance().getBiomeManager().formatPrice(item.buyCost.money))));
        for (Map.Entry<String, Double> bankItem : item.buyCost.bankItems.entrySet()) {
            placeholders.add(new Placeholder(bankItem.getKey() + "_cost", IridiumSkyblock.getInstance().getBiomeManager().formatPrice(bankItem.getValue())));
        }
        return placeholders;
    }

    private List<String> getBiomeLore(Biomes.BiomeItem item) {
        ArrayList<String> lore = item.lore == null ? new ArrayList<String>() : new ArrayList<String>(StringUtils.color(item.lore));
        List<Placeholder> placeholders = this.getBiomeLorePlaceholders(item);
        if (item.buyCost.canPurchase()) {
            lore.add(IridiumSkyblock.getInstance().getBiomes().buyPriceLore);
        } else {
            lore.add(IridiumSkyblock.getInstance().getBiomes().notPurchasableLore);
        }
        if (item.minLevel > 1) {
            lore.add(IridiumSkyblock.getInstance().getBiomes().levelRequirementLore);
        }
        lore.addAll(IridiumSkyblock.getInstance().getBiomes().biomeItemLore);
        return StringUtils.color(StringUtils.processMultiplePlaceholders(lore, placeholders));
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        Optional<Biomes.BiomeItem> biomeItem;
        super.onInventoryClick(event);
        if (this.isPaged()) {
            if (event.getSlot() == this.getInventory().getSize() - 7 && this.canPreviousPage()) {
                --this.page;
                event.getWhoClicked().openInventory(this.getInventory());
            } else if (event.getSlot() == this.getInventory().getSize() - 3 && this.canNextPage()) {
                ++this.page;
                event.getWhoClicked().openInventory(this.getInventory());
            }
        }
        if (!(biomeItem = IridiumSkyblock.getInstance().getBiomes().items.get(this.categoryName).stream().filter(item -> item.slot == event.getSlot()).findAny()).isPresent()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.isLeftClick() && biomeItem.get().buyCost.canPurchase()) {
            IridiumSkyblock.getInstance().getBiomeManager().buy(player, biomeItem.get());
            player.closeInventory();
        } else {
            IridiumSkyblock.getInstance().getBiomes().failSound.play((Entity)player);
        }
    }

    @Generated
    public String getCategoryName() {
        return this.categoryName;
    }
}

