/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.schematics;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.schematics.SchematicPaster;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;

public class WorldEdit
implements SchematicPaster {
    private static final HashMap<File, ClipboardFormat> cachedClipboardFormat = new HashMap();

    public static boolean isWorking() {
        try {
            Platform platform = com.sk89q.worldedit.WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            int liveDataVersion = platform.getDataVersion();
            return liveDataVersion != -1;
        }
        catch (Throwable t) {
            IridiumSkyblock.getInstance().getLogger().warning("WorldEdit threw an error during initializing, make sure it's updated and API compatible(FAWE isn't API compatible) ::" + t.getMessage());
            return false;
        }
    }

    @Override
    public void paste(File file, Location location, Boolean ignoreAirBlock, CompletableFuture<Void> completableFuture) {
        try {
            ClipboardFormat format = cachedClipboardFormat.getOrDefault(file, ClipboardFormats.findByFile((File)file));
            ClipboardReader reader = format.getReader((InputStream)new FileInputStream(file));
            Clipboard clipboard = reader.read();
            int width = clipboard.getDimensions().getBlockX();
            int height = clipboard.getDimensions().getBlockY();
            int length = clipboard.getDimensions().getBlockZ();
            int newLength = (int)((double)length / 2.0);
            int newWidth = (int)((double)width / 2.0);
            int newHeight = (int)((double)height / 2.0);
            location.subtract((double)newWidth, (double)newHeight, (double)newLength);
            clipboard.setOrigin(clipboard.getRegion().getMinimumPoint());
            try (EditSession editSession = com.sk89q.worldedit.WorldEdit.getInstance().newEditSession((World)new BukkitWorld(location.getWorld()));){
                Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(BlockVector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ())).copyEntities(true).ignoreAirBlocks(ignoreAirBlock.booleanValue()).build();
                Operations.complete((Operation)operation);
                Operations.complete((Operation)editSession.commit());
                cachedClipboardFormat.putIfAbsent(file, format);
                completableFuture.complete(null);
            }
        }
        catch (WorldEditException | IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clearCache() {
        cachedClipboardFormat.clear();
    }
}

