/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.bankitems;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.Item;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankItem;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankResponse;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CrystalsBankItem
extends BankItem {
    public CrystalsBankItem(double defaultAmount, Item item) {
        super("Crystals", item, defaultAmount, true, true);
    }

    public CrystalsBankItem(double defaultAmount, Item item, boolean canTransact) {
        super("Crystals", item, defaultAmount, true, canTransact);
    }

    @Override
    public BankResponse withdraw(Player player, Number amount, TeamBank teamBank, IridiumTeams<?, ?> iridiumTeams) {
        if (!this.canTransact) {
            return new BankResponse((int)teamBank.getNumber(), false);
        }
        int crystals = Math.min(amount.intValue(), (int)teamBank.getNumber());
        if (crystals > 0) {
            player.getInventory().addItem(new ItemStack[]{IridiumSkyblock.getInstance().getIslandManager().getIslandCrystal(crystals)}).values().forEach(itemStack -> player.getWorld().dropItem(player.getLocation(), itemStack));
            teamBank.setNumber(teamBank.getNumber() - (double)crystals);
            return new BankResponse(crystals, true);
        }
        return new BankResponse(crystals, false);
    }

    @Override
    public BankResponse deposit(Player player, Number amount, TeamBank teamBank, IridiumTeams<?, ?> iridiumTeams) {
        if (!this.canTransact) {
            return new BankResponse((int)teamBank.getNumber(), false);
        }
        int crystals = this.removeCrystals((Inventory)player.getInventory());
        if (crystals > 0) {
            teamBank.setNumber(teamBank.getNumber() + (double)crystals);
            return new BankResponse(crystals, true);
        }
        return new BankResponse(crystals, false);
    }

    private int removeCrystals(Inventory inventory) {
        int removedCrystals = 0;
        for (int slot = 0; slot < inventory.getContents().length; ++slot) {
            ItemStack itemStack = inventory.getContents()[slot];
            if (itemStack == null) continue;
            int crystalsPerItem = IridiumSkyblock.getInstance().getIslandManager().getIslandCrystals(itemStack);
            int itemStackAmount = itemStack.getAmount();
            if (crystalsPerItem == 0) continue;
            inventory.setItem(slot, null);
            removedCrystals += crystalsPerItem * itemStackAmount;
        }
        return removedCrystals;
    }

    @Generated
    public CrystalsBankItem() {
    }
}

