/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.database;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.database.User;
import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.Color;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Rank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DatabaseField;
import com.iridium.iridiumskyblock.enhancements.SizeEnhancementData;
import com.iridium.iridiumskyblock.managers.IslandManager;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;

public class Island
extends Team {
    @DatabaseField(columnName="color", canBeNull=false)
    private Color color;

    public Island(String name) {
        this.setName(name);
        this.setDescription(IridiumSkyblock.getInstance().getConfiguration().defaultDescription);
        this.setCreateTime(LocalDateTime.now());
        this.color = IridiumSkyblock.getInstance().getConfiguration().defaultBorderColor;
    }

    public Island(int id) {
        this.setId(id);
    }

    @Override
    public int getLevel() {
        return IridiumSkyblock.getInstance().getIslandManager().getTeamLevel(this.getExperience());
    }

    @Override
    public double getValue() {
        return IridiumSkyblock.getInstance().getTeamManager().getTeamValue(this);
    }

    public Location getCenter(World world) {
        Location location;
        if (this.getId() == 1) {
            return new Location(world, 0.0, 0.0, 0.0);
        }
        int position = this.getId() - 1;
        int radius = (int)(Math.floor((Math.sqrt(position) - 1.0) / 2.0) + 1.0);
        int diameter = radius * 2;
        int perimeter = diameter * 4;
        int lastCompletePosition = perimeter * (radius - 1) / 2;
        int currentIndexInPerimeter = (position - lastCompletePosition) % perimeter;
        switch (currentIndexInPerimeter / diameter) {
            case 0: {
                location = new Location(world, (double)(currentIndexInPerimeter - radius), 0.0, (double)(-radius));
                break;
            }
            case 1: {
                location = new Location(world, (double)radius, 0.0, (double)(currentIndexInPerimeter % diameter - radius));
                break;
            }
            case 2: {
                location = new Location(world, (double)(radius - currentIndexInPerimeter % diameter), 0.0, (double)radius);
                break;
            }
            case 3: {
                location = new Location(world, (double)(-radius), 0.0, (double)(radius - currentIndexInPerimeter % diameter));
                break;
            }
            default: {
                throw new IllegalStateException("Could not find island location with ID: " + this.getId());
            }
        }
        return location.multiply((double)IridiumSkyblock.getInstance().getConfiguration().distance);
    }

    public Location getPosition1(World world) {
        if (world == null) {
            double size = (double)this.getSize() / 2.0;
            return this.getCenter(null).subtract(new Location(null, size, 0.0, size));
        }
        double size = (double)this.getSize() / 2.0;
        return this.getCenter(world).subtract(new Location(world, size, 0.0, size));
    }

    public Location getPosition2(World world) {
        if (world == null) {
            double size = (double)this.getSize() / 2.0;
            return this.getCenter(null).add(new Location(null, size, 0.0, size));
        }
        double size = (double)this.getSize() / 2.0;
        return this.getCenter(world).add(new Location(world, size, 0.0, size));
    }

    public Location getMaximumPosition1(World world) {
        if (world == null) {
            double size = (double)this.getMaximumSize() / 2.0;
            return this.getCenter(null).subtract(new Location(null, size, 0.0, size));
        }
        double size = (double)this.getMaximumSize() / 2.0;
        return this.getCenter(world).subtract(new Location(world, size, 0.0, size));
    }

    public Location getMaximumPosition2(World world) {
        if (world == null) {
            double size = (double)this.getMaximumSize() / 2.0;
            return this.getCenter(null).add(new Location(null, size, 0.0, size));
        }
        double size = (double)this.getMaximumSize() / 2.0;
        return this.getCenter(world).add(new Location(world, size, 0.0, size));
    }

    public int getSize() {
        int sizeLevel = IridiumSkyblock.getInstance().getTeamManager().getTeamEnhancement(this, "size").getLevel();
        SizeEnhancementData sizeEnhancementData = (SizeEnhancementData)IridiumSkyblock.getInstance().getEnhancements().sizeEnhancement.levels.get(sizeLevel);
        if (sizeEnhancementData == null) {
            IridiumSkyblock.getInstance().getLogger().warning("size enhancement for level " + sizeLevel + " is null, defaulting to 50");
            return 50;
        }
        return sizeEnhancementData.size;
    }

    public int getMaximumSize() {
        return IridiumSkyblock.getInstance().getEnhancements().sizeEnhancement.levels.values().stream().max(Comparator.comparing(sizeUpgrade -> sizeUpgrade.size)).map(sizeEnhancementData -> sizeEnhancementData.size).orElse(this.getSize());
    }

    public boolean isInIsland(Location location) {
        World world;
        IslandManager islandManager = IridiumSkyblock.getInstance().getTeamManager();
        if (islandManager.isInSkyblockWorld(world = location.getWorld())) {
            return this.isInIsland(location.getBlockX(), location.getBlockZ());
        }
        return false;
    }

    public boolean isInIsland(int x, int z) {
        Location pos1 = this.getPosition1(null);
        Location pos2 = this.getPosition2(null);
        return pos1.getX() <= (double)x && pos1.getZ() <= (double)z && pos2.getX() >= (double)x && pos2.getZ() >= (double)z;
    }

    public void setColor(Color color) {
        this.color = color;
        IridiumSkyblock.getInstance().getTeamManager().getMembersOnIsland(this).forEach(user -> IridiumSkyblock.getInstance().getTeamManager().sendIslandBorder(user.getPlayer()));
    }

    @Override
    @NotNull
    public String getName() {
        if (super.getName() != null) {
            return super.getName();
        }
        String ownerName = this.getOwner().map(IridiumUser::getName).orElse(IridiumSkyblock.getInstance().getMessages().nullPlaceholder);
        return IridiumSkyblock.getInstance().getConfiguration().defaultIslandName.replace("%owner%", ownerName);
    }

    public List<User> getMembers() {
        return IridiumSkyblock.getInstance().getTeamManager().getTeamMembers(this);
    }

    public Optional<User> getOwner() {
        return this.getMembers().stream().filter(user -> user.getUserRank() == Rank.OWNER.getId()).findFirst();
    }

    @Generated
    public Island() {
    }

    @Generated
    public Color getColor() {
        return this.color;
    }
}

