/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.bank;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.Item;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankItem;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankResponse;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.utils.PlayerUtils;
import lombok.Generated;
import org.bukkit.entity.Player;

public class ExperienceBankItem
extends BankItem {
    public ExperienceBankItem(double defaultAmount, Item item) {
        super("experience", item, defaultAmount, true, true);
    }

    public ExperienceBankItem(double defaultAmount, Item item, boolean canTransact) {
        super("experience", item, defaultAmount, true, canTransact);
    }

    @Override
    public BankResponse withdraw(Player player, Number amount, TeamBank teamBank, IridiumTeams<?, ?> iridiumTeams) {
        if (!this.canTransact) {
            return new BankResponse((int)teamBank.getNumber(), false);
        }
        int experience = Math.min(amount.intValue(), (int)teamBank.getNumber());
        if (experience > 0) {
            PlayerUtils.setTotalExperience(player, PlayerUtils.getTotalExperience(player) + experience);
            teamBank.setNumber(teamBank.getNumber() - (double)experience);
            return new BankResponse(experience, true);
        }
        return new BankResponse(experience, false);
    }

    @Override
    public BankResponse deposit(Player player, Number amount, TeamBank teamBank, IridiumTeams<?, ?> iridiumTeams) {
        if (!this.canTransact) {
            return new BankResponse(PlayerUtils.getTotalExperience(player), false);
        }
        int experience = Math.min(amount.intValue(), PlayerUtils.getTotalExperience(player));
        if (experience > 0) {
            PlayerUtils.setTotalExperience(player, PlayerUtils.getTotalExperience(player) - experience);
            teamBank.setNumber(teamBank.getNumber() + (double)experience);
            return new BankResponse(experience, true);
        }
        return new BankResponse(experience, false);
    }

    @Generated
    public ExperienceBankItem() {
    }
}

