/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.bank;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.Item;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankItem;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankResponse;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import lombok.Generated;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class MoneyBankItem
extends BankItem {
    public MoneyBankItem(double defaultAmount, Item item) {
        super("money", item, defaultAmount, true, true);
    }

    public MoneyBankItem(double defaultAmount, Item item, boolean canTransact) {
        super("money", item, defaultAmount, true, canTransact);
    }

    @Override
    public BankResponse withdraw(Player player, Number amount, TeamBank teamBank, IridiumTeams<?, ?> iridiumTeams) {
        if (!this.canTransact) {
            return new BankResponse(teamBank.getNumber(), false);
        }
        double money = Math.min(amount.doubleValue(), teamBank.getNumber());
        if (money > 0.0) {
            EconomyResponse economyResponse = iridiumTeams.getEconomy().depositPlayer((OfflinePlayer)player, money);
            if (economyResponse.type == EconomyResponse.ResponseType.SUCCESS) {
                teamBank.setNumber(teamBank.getNumber() - money);
                return new BankResponse(money, true);
            }
        }
        return new BankResponse(money, false);
    }

    @Override
    public BankResponse deposit(Player player, Number amount, TeamBank teamBank, IridiumTeams<?, ?> iridiumTeams) {
        if (!this.canTransact) {
            return new BankResponse(iridiumTeams.getEconomy().getBalance((OfflinePlayer)player), false);
        }
        double money = Math.min(amount.doubleValue(), iridiumTeams.getEconomy().getBalance((OfflinePlayer)player));
        if (money > 0.0) {
            EconomyResponse economyResponse = iridiumTeams.getEconomy().withdrawPlayer((OfflinePlayer)player, money);
            if (economyResponse.type == EconomyResponse.ResponseType.SUCCESS) {
                teamBank.setNumber(teamBank.getNumber() + money);
                return new BankResponse(money, true);
            }
        }
        return new BankResponse(money, false);
    }

    @Generated
    public MoneyBankItem() {
    }
}

