/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankItem;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.BankGUI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BankCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public String adminPermission;

    public BankCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds, String adminPermission) {
        super(args, description, syntax, permission, cooldownInSeconds);
        this.adminPermission = adminPermission;
    }

    @Override
    public boolean execute(CommandSender sender, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        if (arguments.length == 4) {
            double amount;
            Optional<T> team = iridiumTeams.getTeamManager().getTeamViaNameOrPlayer(arguments[1]);
            if (!team.isPresent()) {
                sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamDoesntExistByName.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return false;
            }
            Optional<BankItem> bankItem = iridiumTeams.getBankItemList().stream().filter(item -> item.getName().equalsIgnoreCase(arguments[2])).findAny();
            try {
                amount = Double.parseDouble(arguments[3]);
            }
            catch (NumberFormatException exception) {
                sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().notANumber.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return false;
            }
            if (!sender.hasPermission(this.adminPermission)) {
                sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().noPermission.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return false;
            }
            if (!bankItem.isPresent()) {
                sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().noSuchBankItem.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return false;
            }
            TeamBank teamBank = iridiumTeams.getTeamManager().getTeamBank((Team)team.get(), bankItem.get().getName());
            switch (arguments[0].toLowerCase()) {
                case "give": {
                    teamBank.setNumber(teamBank.getNumber() + amount);
                    sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().gaveBank.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", arguments[1]).replace("%amount%", String.valueOf(amount)).replace("%item%", bankItem.get().getName())));
                    break;
                }
                case "remove": {
                    teamBank.setNumber(teamBank.getNumber() - amount);
                    sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().removedBank.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", arguments[1]).replace("%amount%", String.valueOf(amount)).replace("%item%", bankItem.get().getName())));
                    break;
                }
                case "set": {
                    teamBank.setNumber(amount);
                    sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().setBank.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", arguments[1]).replace("%amount%", String.valueOf(amount)).replace("%item%", bankItem.get().getName())));
                    break;
                }
                default: {
                    sender.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                }
            }
            return true;
        }
        if (arguments.length != 0) {
            sender.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        return super.execute(sender, arguments, iridiumTeams);
    }

    @Override
    public boolean execute(U user, T team, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        player.openInventory(new BankGUI<T, U>(team, player, iridiumTeams).getInventory());
        return false;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        if (!commandSender.hasPermission(this.adminPermission)) {
            return Collections.emptyList();
        }
        switch (args.length) {
            case 1: {
                return Arrays.asList("give", "set", "remove");
            }
            case 2: {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            }
            case 3: {
                return iridiumTeams.getBankItemList().stream().map(BankItem::getName).collect(Collectors.toList());
            }
            case 4: {
                return Arrays.asList("1", "10", "100");
            }
        }
        return Collections.emptyList();
    }

    @Generated
    public BankCommand() {
    }
}

