/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.LogType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamEnhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamLog;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.Enhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.EnhancementType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.BoostersGUI;
import java.util.List;
import lombok.Generated;
import org.bukkit.entity.Player;

public class BoostersCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public BoostersCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length == 0) {
            player.openInventory(new BoostersGUI<T, U>(team, player, iridiumTeams).getInventory());
            return false;
        }
        if (args.length != 2 || !args[0].equalsIgnoreCase("buy")) {
            player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        String booster = args[1];
        Enhancement<?> enhancement = iridiumTeams.getEnhancementList().get(booster);
        if (enhancement == null || enhancement.type != EnhancementType.BOOSTER) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().noSuchBooster.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        TeamEnhancement teamEnhancement = iridiumTeams.getTeamManager().getTeamEnhancement(team, booster);
        boolean success = iridiumTeams.getTeamManager().UpdateEnhancement(team, booster, player);
        if (success) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().purchasedBooster.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%booster%", booster)));
            iridiumTeams.getTeamManager().saveTeamLog(new TeamLog((Team)team, LogType.TEAM_BOOSTER_PURCHASE, iridiumTeams.getTeamLogs().teamBoosterPurchaseDescription.replace("%upgrade_type%", teamEnhancement.getEnhancementName()).replace("%level%", String.valueOf(teamEnhancement.getLevel())), ((IridiumUser)user).getUuid()));
        }
        return success;
    }

    @Generated
    public BoostersCommand() {
    }
}

