/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.LogType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamLog;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamWarp;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.entity.Player;

public class EditWarpCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public EditWarpCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length < 2) {
            player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (!iridiumTeams.getTeamManager().getTeamPermission(team, user, PermissionType.MANAGE_WARPS)) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().cannotManageWarps.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        Optional<TeamWarp> teamWarp = iridiumTeams.getTeamManager().getTeamWarp(team, args[0]);
        if (!teamWarp.isPresent()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().unknownWarp.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        switch (args[1]) {
            case "icon": {
                if (args.length != 3) {
                    player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                    return false;
                }
                Optional<XMaterial> xMaterial = XMaterial.matchXMaterial(args[2]);
                if (!xMaterial.isPresent()) {
                    player.sendMessage(StringUtils.color(iridiumTeams.getMessages().noSuchMaterial.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                    return false;
                }
                teamWarp.get().setIcon(xMaterial.get());
                iridiumTeams.getTeamManager().saveTeamLog(new TeamLog((Team)team, LogType.TEAM_WARP_EDIT, iridiumTeams.getTeamLogs().teamWarpEditDescription.replace("%warp%", teamWarp.get().getName()).replace("%type%", "Icon"), ((IridiumUser)user).getUuid()));
                player.sendMessage(StringUtils.color(iridiumTeams.getMessages().warpIconSet.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return true;
            }
            case "description": {
                if (args.length < 3) {
                    player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                    return false;
                }
                String description = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                teamWarp.get().setDescription(description);
                iridiumTeams.getTeamManager().saveTeamLog(new TeamLog((Team)team, LogType.TEAM_WARP_EDIT, iridiumTeams.getTeamLogs().teamWarpEditDescription.replace("%warp%", teamWarp.get().getName()).replace("%type%", "Description"), ((IridiumUser)user).getUuid()));
                player.sendMessage(StringUtils.color(iridiumTeams.getMessages().warpDescriptionSet.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return true;
            }
        }
        player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
        return false;
    }

    @Override
    public List<String> onTabComplete(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        List<TeamWarp> teamWarps = iridiumTeams.getTeamManager().getTeamWarps(team);
        switch (args.length) {
            case 1: {
                return teamWarps.stream().map(TeamWarp::getName).collect(Collectors.toList());
            }
            case 2: {
                return Arrays.asList("icon", "description");
            }
            case 3: {
                if (!args[1].equalsIgnoreCase("icon")) break;
                return Arrays.stream(XMaterial.values()).map(Enum::name).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    @Generated
    public EditWarpCommand() {
    }
}

