/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.LogType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.SettingType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamInvite;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamLog;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.MembersEnhancementData;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JoinCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public JoinCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length != 1) {
            player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (iridiumTeams.getTeamManager().getTeamViaID(((IridiumUser)user).getTeamID()).isPresent()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().alreadyHaveTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        Optional<T> team = iridiumTeams.getTeamManager().getTeamViaNameOrPlayer(args[0]);
        if (!team.isPresent()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamDoesntExistByName.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        TeamSetting teamSetting = iridiumTeams.getTeamManager().getTeamSetting((Team)team.get(), SettingType.TEAM_TYPE.getSettingKey());
        Optional<TeamInvite> teamInvite = iridiumTeams.getTeamManager().getTeamInvite((Team)team.get(), user);
        if (!(teamInvite.isPresent() || ((IridiumUser)user).isBypassing() || teamSetting == null || teamSetting.getValue().equalsIgnoreCase("public"))) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().noActiveInvite.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        MembersEnhancementData data = (MembersEnhancementData)iridiumTeams.getEnhancements().membersEnhancement.levels.get(iridiumTeams.getTeamManager().getTeamEnhancement((Team)team.get(), "members").getLevel());
        if (iridiumTeams.getTeamManager().getTeamMembers((Team)team.get()).size() >= (data == null ? 0 : data.members)) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().memberLimitReached.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        ((IridiumUser)user).setTeam((Team)((Team)team.get()));
        teamInvite.ifPresent(invite -> iridiumTeams.getTeamManager().deleteTeamInvite((TeamInvite)invite));
        iridiumTeams.getTeamManager().saveTeamLog(new TeamLog((Team)team.get(), LogType.TEAM_JOIN, iridiumTeams.getTeamLogs().teamJoinLogDescription, ((IridiumUser)user).getUuid()));
        player.sendMessage(StringUtils.color(iridiumTeams.getMessages().joinedTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%name%", ((Team)team.get()).getName())));
        iridiumTeams.getTeamManager().getTeamMembers((Team)team.get()).stream().map(IridiumUser::getPlayer).forEach(teamMember -> {
            if (teamMember != null && teamMember != player) {
                teamMember.sendMessage(StringUtils.color(iridiumTeams.getMessages().userJoinedTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", player.getName())));
            }
        });
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
    }

    @Generated
    public JoinCommand() {
    }
}

