/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RecalculateCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public RecalculateCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(CommandSender sender, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        if (iridiumTeams.isRecalculating()) {
            sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().calculationAlreadyInProcess.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        int interval = iridiumTeams.getConfiguration().forceRecalculateInterval;
        List<T> teams = iridiumTeams.getTeamManager().getTeams();
        int seconds = teams.size() * interval / 20 % 60;
        int minutes = teams.size() * interval / 20 / 60;
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!player.hasPermission(this.permission)) continue;
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().calculatingTeams.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", sender.getName()).replace("%minutes%", String.valueOf(minutes)).replace("%seconds%", String.valueOf(seconds)).replace("%amount%", String.valueOf(teams.size()))));
        }
        iridiumTeams.setRecalculating(true);
        return true;
    }

    @Generated
    public RecalculateCommand() {
    }
}

