/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.LogType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Setting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.api.SettingUpdateEvent;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamLog;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.SettingsGUI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SettingsCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public SettingsCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length == 0) {
            player.openInventory(new SettingsGUI<T, U>(team, player, iridiumTeams).getInventory());
            return true;
        }
        if (args.length == 2) {
            if (!iridiumTeams.getTeamManager().getTeamPermission(team, user, PermissionType.SETTINGS)) {
                player.sendMessage(StringUtils.color(iridiumTeams.getMessages().cannotChangeSettings.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return false;
            }
            String settingKey = args[0];
            for (Map.Entry<String, Setting> setting : iridiumTeams.getSettingsList().entrySet()) {
                if (!setting.getValue().getDisplayName().equalsIgnoreCase(settingKey)) continue;
                TeamSetting teamSetting = iridiumTeams.getTeamManager().getTeamSetting(team, setting.getKey());
                Optional<String> value = setting.getValue().getValues().stream().filter(s -> s.equalsIgnoreCase(args[1])).findFirst();
                if (!value.isPresent() || teamSetting == null) {
                    player.sendMessage(StringUtils.color(iridiumTeams.getMessages().invalidSettingValue.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                    return false;
                }
                teamSetting.setValue(value.get());
                iridiumTeams.getTeamManager().saveTeamLog(new TeamLog((Team)team, LogType.TEAM_SETTINGS, iridiumTeams.getTeamLogs().teamSettingsDescription.replace("%setting%", setting.getKey()).replace("%value%", value.get()), ((IridiumUser)user).getUuid()));
                player.sendMessage(StringUtils.color(iridiumTeams.getMessages().settingSet.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%setting%", setting.getValue().getDisplayName()).replace("%value%", value.get())));
                Bukkit.getPluginManager().callEvent(new SettingUpdateEvent<T, U>(team, user, setting.getKey(), value.get()));
                return true;
            }
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().invalidSetting.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
        return false;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        switch (args.length) {
            case 1: {
                return iridiumTeams.getSettingsList().values().stream().map(Setting::getDisplayName).collect(Collectors.toList());
            }
            case 2: {
                for (Map.Entry<String, Setting> setting : iridiumTeams.getSettingsList().entrySet()) {
                    if (!setting.getValue().getDisplayName().equalsIgnoreCase(args[0])) continue;
                    return setting.getValue().getValues();
                }
                break;
            }
        }
        return Collections.emptyList();
    }

    @Generated
    public SettingsCommand() {
    }
}

