/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.LogType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamLog;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TrustCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public TrustCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length != 1) {
            player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (!iridiumTeams.getTeamManager().getTeamPermission(team, user, PermissionType.TRUST)) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().cannotTrust.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        Player invitee = Bukkit.getServer().getPlayer(args[0]);
        if (invitee == null) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().notAPlayer.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        U offlinePlayerUser = iridiumTeams.getUserManager().getUser((OfflinePlayer)invitee);
        if (((IridiumUser)offlinePlayerUser).getTeamID() == ((Team)team).getId()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().userAlreadyInTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (iridiumTeams.getTeamManager().getTeamTrust(team, offlinePlayerUser).isPresent()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().trustAlreadyPresent.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        iridiumTeams.getTeamManager().createTeamTrust(team, offlinePlayerUser, user);
        iridiumTeams.getTeamManager().saveTeamLog(new TeamLog((Team)team, LogType.TEAM_TRUST, iridiumTeams.getTeamLogs().teamTrustDescription, ((IridiumUser)user).getUuid(), ((IridiumUser)offlinePlayerUser).getUuid()));
        player.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamTrustSent.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", ((IridiumUser)offlinePlayerUser).getName())));
        invitee.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamTrustReceived.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", player.getName())));
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
    }

    @Generated
    public TrustCommand() {
    }
}

