/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.configs;

import com.google.common.collect.ImmutableMap;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.Item;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.NumberFormatter;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Reward;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.UserRank;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import com.iridium.iridiumskyblock.dependencies.xseries.XSound;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Configuration {
    public String prefix;
    public boolean updateChecks;
    public String dateTimeFormat;
    public NumberFormatter numberFormatter;
    public boolean createRequiresName;
    public boolean preventTntGriefing;
    public boolean patreonMessage;
    public int minTeamNameLength;
    public int maxTeamNameLength;
    public int recalculateInterval;
    public int forceRecalculateInterval;
    public boolean enableLeveling;
    public boolean giveLevelRewards;
    public int flatExpRequirement;
    public double curvedExpModifier;
    public Map<Integer, UserRank> userRanks;
    public UserRank visitor;
    public UserRank owner;
    public String teamInfoTitle;
    public String teamInfoTitleFiller;
    public List<String> teamInfo;
    public List<String> levelInfo;
    public List<String> noneChatAlias;
    public List<String> teamChatAlias;
    public Map<Integer, Integer> teamTopSlots;
    public Map<Integer, Integer> teamWarpSlots;
    public int teleportDelay;
    public double teleportMovementThreshold;
    public String teleportBypassPermission;
    public Map<Integer, Reward> levelRewards;
    public List<String> whitelistedWorlds;

    public Configuration() {
        this("&c", "Team", "IridiumTeams");
    }

    public Configuration(String color, String team, String pluginName) {
        this.prefix = color + "&l" + pluginName + " &8\u00bb";
        this.updateChecks = true;
        this.dateTimeFormat = "EEEE, MMMM dd HH:mm:ss";
        this.numberFormatter = new NumberFormatter();
        this.createRequiresName = true;
        this.preventTntGriefing = true;
        this.patreonMessage = true;
        this.minTeamNameLength = 3;
        this.maxTeamNameLength = 20;
        this.recalculateInterval = 5;
        this.forceRecalculateInterval = 1;
        this.enableLeveling = true;
        this.giveLevelRewards = true;
        this.flatExpRequirement = 10;
        this.curvedExpModifier = 0.95;
        this.userRanks = new ImmutableMap.Builder().put((Object)1, (Object)new UserRank("Member", new Item(XMaterial.STONE_AXE, 12, 1, "&9&lMember", Collections.emptyList()))).put((Object)2, (Object)new UserRank("Moderator", new Item(XMaterial.IRON_AXE, 13, 1, "&5&lModerator", Collections.emptyList()))).put((Object)3, (Object)new UserRank("CoOwner", new Item(XMaterial.GOLDEN_AXE, 14, 1, "&2&lCoOwner", Collections.emptyList()))).build();
        this.visitor = new UserRank("Visitor", new Item(XMaterial.WOODEN_AXE, 11, 1, "&7&lVisitor", Collections.emptyList()));
        this.owner = new UserRank("Owner", new Item(XMaterial.DIAMOND_AXE, 15, 1, "&c&lOwner", Collections.emptyList()));
        this.teamInfoTitle = "&8[ " + color + "&l%" + team.toLowerCase() + "_name% &8]";
        this.teamInfoTitleFiller = "&8&m ";
        this.teamInfo = Arrays.asList(color + "Description: &7%" + team.toLowerCase() + "_description%", color + "Level: &7%" + team.toLowerCase() + "_level% (#%" + team.toLowerCase() + "_experience_rank%)", color + "Value: &7%" + team.toLowerCase() + "_value% (#%" + team.toLowerCase() + "_value_rank%)", color + "Online Members (%" + team.toLowerCase() + "_members_online_count%/%" + team.toLowerCase() + "_members_count%): &7%" + team.toLowerCase() + "_members_online%", color + "Offline Members (%" + team.toLowerCase() + "_members_offline_count%/%" + team.toLowerCase() + "_members_count%): &7%" + team.toLowerCase() + "_members_offline%");
        this.levelInfo = Arrays.asList(color + "Level: &7%" + team.toLowerCase() + "_level%", color + "Experience: &7%" + team.toLowerCase() + "_experience% / %" + team.toLowerCase() + "_experienceForNextLevel% (need %" + team.toLowerCase() + "_experienceToLevelUp% more)");
        this.noneChatAlias = Arrays.asList("n", "none");
        this.teamChatAlias = Arrays.asList(team.toLowerCase().substring(0, 1), team.toLowerCase());
        this.teamTopSlots = new ImmutableMap.Builder().put((Object)1, (Object)14).put((Object)2, (Object)22).put((Object)3, (Object)23).put((Object)4, (Object)24).put((Object)5, (Object)30).put((Object)6, (Object)31).put((Object)7, (Object)32).put((Object)8, (Object)33).put((Object)9, (Object)34).build();
        this.teamWarpSlots = ImmutableMap.builder().put((Object)1, (Object)9).put((Object)2, (Object)11).put((Object)3, (Object)13).put((Object)4, (Object)15).put((Object)5, (Object)17).build();
        this.levelRewards = ImmutableMap.builder().put((Object)1, (Object)new Reward(new Item(XMaterial.EXPERIENCE_BOTTLE, 1, "&b&lLevel %" + team.toLowerCase() + "_level% Reward", Arrays.asList("&7" + team + " Level %" + team.toLowerCase() + "_level% Rewards:", "&b&l* &b200 Money", "", "&b&l[!] &bLeft click to redeem")), Collections.emptyList(), 0.0, new HashMap<String, Double>(), 200, 0, XSound.ENTITY_PLAYER_LEVELUP)).put((Object)5, (Object)new Reward(new Item(XMaterial.EXPERIENCE_BOTTLE, 1, "&b&lLevel %" + team.toLowerCase() + "_level% Reward", Arrays.asList("&7" + team + " Level %" + team.toLowerCase() + "_level% Rewards:", "&b&l* &b2000 Money", "", "&b&l[!] &bLeft click to redeem")), Collections.emptyList(), 0.0, new HashMap<String, Double>(), 2000, 0, XSound.ENTITY_PLAYER_LEVELUP)).build();
        this.whitelistedWorlds = Collections.emptyList();
        this.teleportDelay = 0;
        this.teleportMovementThreshold = 0.5;
        this.teleportBypassPermission = pluginName.toLowerCase().replace(" ", "") + ".teleport.bypass";
    }
}

