/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.database;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.DatabaseObject;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamEnhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.Enhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.EnhancementAffectsType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.EnhancementData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.FlightEnhancementData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.PotionEnhancementData;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DatabaseField;
import com.iridium.iridiumskyblock.dependencies.ormlite.table.DatabaseTable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

@DatabaseTable(tableName="users")
public class IridiumUser<T extends Team>
extends DatabaseObject {
    @DatabaseField(columnName="uuid", canBeNull=false, id=true)
    @NotNull
    private UUID uuid;
    @DatabaseField(columnName="name", canBeNull=false)
    @NotNull
    private String name;
    @DatabaseField(columnName="team_id")
    private int teamID;
    @DatabaseField(columnName="user_rank", canBeNull=false)
    private int userRank;
    @DatabaseField(columnName="join_time")
    private LocalDateTime joinTime;
    @DatabaseField(columnName="active_profile", canBeNull=false)
    @NotNull
    private UUID activeProfile = UUID.randomUUID();
    private boolean bypassing;
    private boolean flying;
    private String chatType = "";
    private BukkitTask bukkitTask;
    private int bukkitTaskTicks = 0;

    public void setTeam(T t) {
        this.teamID = t == null ? 0 : ((Team)t).getId();
        this.setJoinTime(LocalDateTime.now());
        this.userRank = 1;
    }

    public Player getPlayer() {
        return Bukkit.getServer().getPlayer(this.uuid);
    }

    public boolean canFly(IridiumTeams<T, ?> iridiumTeams) {
        Player player = this.getPlayer();
        if (this.isBypassing()) {
            return true;
        }
        if (player.hasPermission(iridiumTeams.getCommands().flyCommand.getFlyAnywherePermission())) {
            return true;
        }
        Optional<Team> team = iridiumTeams.getTeamManager().getTeamViaID(this.getTeamID());
        Optional<Team> visitor = iridiumTeams.getTeamManager().getTeamViaPlayerLocation(player);
        if (player.hasPermission(iridiumTeams.getCommands().flyCommand.permission) && team.isPresent() && team.map(Team::getId).orElse(-1).equals(visitor.map(Team::getId).orElse(-1))) {
            return true;
        }
        return this.canFly(team.orElse(null), iridiumTeams) || this.canFly(visitor.orElse(null), iridiumTeams);
    }

    private boolean canFly(T team, IridiumTeams<T, ?> iridiumTeams) {
        if (team == null) {
            return false;
        }
        Enhancement<FlightEnhancementData> flightEnhancement = iridiumTeams.getEnhancements().flightEnhancement;
        TeamEnhancement teamEnhancement = iridiumTeams.getTeamManager().getTeamEnhancement(team, "flight");
        FlightEnhancementData data = (FlightEnhancementData)flightEnhancement.levels.get(teamEnhancement.getLevel());
        if (!teamEnhancement.isActive(flightEnhancement.type)) {
            return false;
        }
        if (data == null) {
            return false;
        }
        return this.canApply(iridiumTeams, team, data.enhancementAffectsType);
    }

    public void initBukkitTask(IridiumTeams<T, ?> iridiumTeams) {
        if (this.bukkitTask != null) {
            return;
        }
        this.bukkitTask = Bukkit.getScheduler().runTaskTimer(iridiumTeams, () -> this.bukkitTask(iridiumTeams), 0L, 20L);
    }

    public void bukkitTask(IridiumTeams<T, ?> iridiumTeams) {
        ++this.bukkitTaskTicks;
        this.applyPotionEffects(iridiumTeams);
    }

    public void applyPotionEffects(IridiumTeams<T, ?> iridiumTeams) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        iridiumTeams.getTeamManager().getTeamViaLocation(player.getLocation()).ifPresent(t -> this.applyPotionEffects(iridiumTeams, t));
        iridiumTeams.getTeamManager().getTeamViaID(this.teamID).ifPresent(t -> this.applyPotionEffects(iridiumTeams, t));
    }

    public void applyPotionEffects(IridiumTeams<T, ?> iridiumTeams, T team) {
        int duration = 10;
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        HashMap<PotionEffectType, Integer> potionEffects = new HashMap<PotionEffectType, Integer>();
        for (Map.Entry<String, Enhancement<?>> entry : iridiumTeams.getEnhancementList().entrySet()) {
            EnhancementData enhancementData;
            TeamEnhancement teamEnhancement = iridiumTeams.getTeamManager().getTeamEnhancement(team, entry.getKey());
            if (!teamEnhancement.isActive(entry.getValue().type) || !((enhancementData = (EnhancementData)entry.getValue().levels.get(teamEnhancement.getLevel())) instanceof PotionEnhancementData)) continue;
            PotionEnhancementData potionEnhancementData = (PotionEnhancementData)enhancementData;
            if (!this.canApply(iridiumTeams, team, potionEnhancementData.enhancementAffectsType)) continue;
            PotionEffectType potionEffectType = potionEnhancementData.potion.getPotionEffectType();
            if (!potionEffects.containsKey(potionEffectType)) {
                potionEffects.put(potionEffectType, potionEnhancementData.strength - 1);
                continue;
            }
            if ((Integer)potionEffects.get(potionEffectType) >= potionEnhancementData.strength - 1) continue;
            potionEffects.put(potionEffectType, potionEnhancementData.strength - 1);
        }
        for (Map.Entry<String, Enhancement<Object>> entry : potionEffects.entrySet()) {
            Optional<PotionEffect> potionEffect = player.getActivePotionEffects().stream().filter(effect -> effect.getType().equals(potionEffectType.getKey())).findFirst();
            if (potionEffect.isPresent() && potionEffect.get().getAmplifier() <= (Integer)((Object)entry.getValue()) && potionEffect.get().getDuration() <= duration * 20) {
                player.removePotionEffect((PotionEffectType)entry.getKey());
            }
            player.addPotionEffect(((PotionEffectType)entry.getKey()).createEffect(duration * 20, ((Integer)((Object)entry.getValue())).intValue()));
        }
    }

    public boolean canApply(IridiumTeams<T, ?> iridiumTeams, T team, List<EnhancementAffectsType> enhancementAffectsTypes) {
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        int teamLocationID = iridiumTeams.getTeamManager().getTeamViaLocation(player.getLocation()).map(Team::getId).orElse(0);
        for (EnhancementAffectsType enhancementAffectsType : enhancementAffectsTypes) {
            if (enhancementAffectsType == EnhancementAffectsType.VISITORS && ((Team)team).getId() == teamLocationID) {
                return true;
            }
            if (enhancementAffectsType == EnhancementAffectsType.MEMBERS_ANYWHERE && ((Team)team).getId() == this.teamID) {
                return true;
            }
            if (enhancementAffectsType != EnhancementAffectsType.MEMBERS_IN_TERRITORY || ((Team)team).getId() != this.teamID || ((Team)team).getId() != teamLocationID) continue;
            return true;
        }
        return false;
    }

    public void setUuid(@NotNull UUID uuid) {
        this.uuid = uuid;
        this.setChanged(true);
    }

    public void setName(@NotNull String name) {
        this.name = name;
        this.setChanged(true);
    }

    public void setTeamID(int teamID) {
        this.teamID = teamID;
        this.setChanged(true);
    }

    public void setUserRank(int userRank) {
        this.userRank = userRank;
        this.setChanged(true);
    }

    public void setJoinTime(LocalDateTime joinTime) {
        this.joinTime = joinTime;
        this.setChanged(true);
    }

    public void setBypassing(boolean bypassing) {
        this.bypassing = bypassing;
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
    }

    public void setChatType(String chatType) {
        this.chatType = chatType;
    }

    @NotNull
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getTeamID() {
        return this.teamID;
    }

    @Generated
    public int getUserRank() {
        return this.userRank;
    }

    @Generated
    public LocalDateTime getJoinTime() {
        return this.joinTime;
    }

    @NotNull
    @Generated
    public UUID getActiveProfile() {
        return this.activeProfile;
    }

    @Generated
    public boolean isBypassing() {
        return this.bypassing;
    }

    @Generated
    public boolean isFlying() {
        return this.flying;
    }

    @Generated
    public String getChatType() {
        return this.chatType;
    }

    @Generated
    public BukkitTask getBukkitTask() {
        return this.bukkitTask;
    }

    @Generated
    public int getBukkitTaskTicks() {
        return this.bukkitTaskTicks;
    }
}

