/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.database;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.api.TeamLevelUpEvent;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.DatabaseObject;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DatabaseField;
import com.iridium.iridiumskyblock.dependencies.ormlite.table.DatabaseTable;
import java.time.LocalDateTime;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;

@DatabaseTable(tableName="teams")
public abstract class Team
extends DatabaseObject {
    @DatabaseField(columnName="id", canBeNull=false, generatedId=true)
    private int id;
    @DatabaseField(columnName="name")
    private String name;
    @DatabaseField(columnName="description", canBeNull=false)
    @NotNull
    private String description;
    @DatabaseField(columnName="create_time")
    private LocalDateTime createTime;
    @DatabaseField(columnName="home")
    private Location home;
    @DatabaseField(columnName="experience")
    private int experience;
    @DatabaseField(columnName="max_experience")
    private int maxExperience;

    public abstract int getLevel();

    public abstract double getValue();

    public void setId(int id) {
        this.id = id;
        this.setChanged(true);
    }

    public void setName(String name) {
        this.name = name;
        this.setChanged(true);
    }

    public void setDescription(@NotNull String description) {
        this.description = description;
        this.setChanged(true);
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
        this.setChanged(true);
    }

    public void setHome(Location home) {
        this.home = home;
        this.setChanged(true);
    }

    public void setExperience(int experience) {
        int currentLevel = this.getLevel();
        this.experience = Math.max(0, experience);
        int newLevel = this.getLevel();
        if (newLevel != currentLevel) {
            Bukkit.getPluginManager().callEvent(new TeamLevelUpEvent(this, newLevel));
        }
        this.maxExperience = Math.max(this.maxExperience, experience);
        this.setChanged(true);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @NotNull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Location getHome() {
        return this.home;
    }

    @Generated
    public int getExperience() {
        return this.experience;
    }

    @Generated
    public int getMaxExperience() {
        return this.maxExperience;
    }
}

