/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.database.types;

import com.iridium.iridiumskyblock.dependencies.ormlite.field.FieldType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.SqlType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.types.StringType;
import com.iridium.iridiumskyblock.dependencies.snakeyaml.external.biz.base64Coder.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class InventoryType
extends StringType {
    private static final InventoryType instance = new InventoryType();

    public static InventoryType getSingleton() {
        return instance;
    }

    protected InventoryType() {
        super(SqlType.STRING, new Class[]{Inventory.class});
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        String value = (String)super.sqlArgToJava(fieldType, sqlArg, columnPos);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)value));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            Inventory inventory = Bukkit.getServer().createInventory(null, dataInput.readInt());
            for (int i = 0; i < inventory.getSize(); ++i) {
                inventory.setItem(i, (ItemStack)dataInput.readObject());
            }
            dataInput.close();
            return inventory;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to deserialize Inventory", e);
        }
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object object) {
        Inventory inventory = (Inventory)object;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(inventory.getSize());
            for (int i = 0; i < inventory.getSize(); ++i) {
                dataOutput.writeObject((Object)inventory.getItem(i));
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to serialize Inventory", e);
        }
    }
}

