/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.PagedGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.BlockValues;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.NoItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class BlockValueGUI<T extends Team, U extends IridiumUser<T>>
extends PagedGUI<BlockValues.ValuableBlock> {
    private final T team;
    private final IridiumTeams<T, U> iridiumTeams;

    public BlockValueGUI(T team, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(1, iridiumTeams.getInventories().blockValueGUI.size, iridiumTeams.getInventories().blockValueGUI.background, iridiumTeams.getInventories().previousPage, iridiumTeams.getInventories().nextPage, player, iridiumTeams.getInventories().backButton);
        this.team = team;
        this.iridiumTeams = iridiumTeams;
    }

    @NotNull
    public Inventory getInventory() {
        int maxPages = this.getPageObjects().size() / (this.getSize() - 9);
        if (this.getPageObjects().size() % (this.getSize() - 9) > 0) {
            ++maxPages;
        }
        NoItemGUI noItemGUI = this.iridiumTeams.getInventories().blockValueGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSize(), (String)StringUtils.color(noItemGUI.title.replace("%page%", String.valueOf(this.getPage())).replace("%max_pages%", String.valueOf(maxPages))));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        for (Map.Entry entry2 : this.iridiumTeams.getBlockValues().blockValues.entrySet().stream().filter(entry -> ((BlockValues.ValuableBlock)entry.getValue()).page == this.getPage()).collect(Collectors.toList())) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(this.iridiumTeams.getBlockValues().valueLore.replace("%block_value%", String.valueOf(((BlockValues.ValuableBlock)entry2.getValue()).value)));
            lore.add(this.iridiumTeams.getBlockValues().teamValueLore.replace("%total_blocks%", String.valueOf(this.iridiumTeams.getTeamManager().getTeamBlock(this.team, (XMaterial)entry2.getKey()).getAmount())).replace("%total_block_value%", String.valueOf((double)this.iridiumTeams.getTeamManager().getTeamBlock(this.team, (XMaterial)entry2.getKey()).getAmount() * ((BlockValues.ValuableBlock)entry2.getValue()).value)));
            inventory.setItem(((BlockValues.ValuableBlock)entry2.getValue()).slot, ItemStackUtils.makeItem((XMaterial)entry2.getKey(), 1, ((BlockValues.ValuableBlock)entry2.getValue()).name, lore));
        }
    }

    @Override
    public Collection<BlockValues.ValuableBlock> getPageObjects() {
        return this.iridiumTeams.getBlockValues().blockValues.values();
    }

    @Override
    public ItemStack getItemStack(BlockValues.ValuableBlock valuableBlock) {
        return null;
    }
}

