/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.PagedGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.SingleItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class MembersGUI<T extends Team, U extends IridiumUser<T>>
extends PagedGUI<U> {
    private final IridiumTeams<T, U> iridiumTeams;
    private final T team;

    public MembersGUI(T team, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(1, iridiumTeams.getInventories().membersGUI.size, iridiumTeams.getInventories().membersGUI.background, iridiumTeams.getInventories().previousPage, iridiumTeams.getInventories().nextPage, player, iridiumTeams.getInventories().backButton);
        this.iridiumTeams = iridiumTeams;
        this.team = team;
    }

    @NotNull
    public Inventory getInventory() {
        SingleItemGUI noItemGUI = this.iridiumTeams.getInventories().membersGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSize(), (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public Collection<U> getPageObjects() {
        return this.iridiumTeams.getTeamManager().getTeamMembers(this.team);
    }

    @Override
    public ItemStack getItemStack(U user) {
        return ItemStackUtils.makeItem(this.iridiumTeams.getInventories().membersGUI.item, this.iridiumTeams.getUserPlaceholderBuilder().getPlaceholders(user));
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        IridiumUser user = (IridiumUser)this.getItem(event.getSlot());
        if (user == null) {
            return;
        }
        switch (event.getClick()) {
            case LEFT: {
                if (user.getUserRank() != 1) {
                    this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().demoteCommand, new String[]{user.getName()});
                    break;
                }
                this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().kickCommand, new String[]{user.getName()});
                break;
            }
            case RIGHT: {
                this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().promoteCommand, new String[]{user.getName()});
            }
        }
    }
}

