/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.NoItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamMission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.missions.Mission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.missions.MissionData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.missions.MissionType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class MissionGUI<T extends Team, U extends IridiumUser<T>>
extends BackGUI {
    private final T team;
    private final MissionType missionType;
    private final IridiumTeams<T, U> iridiumTeams;

    public MissionGUI(T team, MissionType missionType, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().missionGUI.get((Object)((Object)missionType)).background, player, iridiumTeams.getInventories().backButton);
        this.team = team;
        this.missionType = missionType;
        this.iridiumTeams = iridiumTeams;
    }

    @NotNull
    public Inventory getInventory() {
        NoItemGUI noItemGUI = this.iridiumTeams.getInventories().missionGUI.get((Object)this.missionType);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)noItemGUI.size, (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        List<TeamMission> teamMissions = this.iridiumTeams.getTeamManager().getTeamMissions(this.team);
        for (Map.Entry<String, Mission> entry : this.iridiumTeams.getMissions().missions.entrySet()) {
            if (entry.getValue().getMissionType() != this.missionType) continue;
            Optional<TeamMission> teamMission = teamMissions.stream().filter(m -> m.getMissionName().equals(entry.getKey())).findFirst();
            int level = teamMission.map(TeamMission::getMissionLevel).orElse(1);
            if (teamMission.isPresent() && teamMission.get().hasExpired()) {
                this.iridiumTeams.getTeamManager().deleteTeamMission(teamMission.get());
                this.iridiumTeams.getTeamManager().deleteTeamMissionData(teamMission.get());
                level = 1;
            }
            MissionData missionData = entry.getValue().getMissionData().get(level);
            if (missionData.getItem().slot == null) continue;
            inventory.setItem(missionData.getItem().slot.intValue(), this.getItem(entry.getKey()));
        }
        List<String> missions = this.iridiumTeams.getTeamManager().getTeamMission(this.team, this.missionType);
        int index = 0;
        for (String missionName : missions) {
            if (this.iridiumTeams.getMissions().dailySlots.size() <= index) continue;
            int slot = this.iridiumTeams.getMissions().dailySlots.get(index);
            inventory.setItem(slot, this.getItem(missionName));
            ++index;
        }
    }

    private ItemStack getItem(String missionName) {
        TeamMission teamMission = this.iridiumTeams.getTeamManager().getTeamMission(this.team, missionName);
        Mission mission = this.iridiumTeams.getMissions().missions.get(missionName);
        MissionData missionData = mission.getMissionData().get(teamMission.getMissionLevel());
        List<Placeholder> placeholders = IntStream.range(0, missionData.getMissions().size()).boxed().map(integer -> this.iridiumTeams.getTeamManager().getTeamMissionData(teamMission, (int)integer)).map(islandMission -> new Placeholder("progress_" + (islandMission.getMissionIndex() + 1), String.valueOf(islandMission.getProgress()))).collect(Collectors.toList());
        int seconds = Math.max((int)(teamMission.getRemainingTime() % 60L), 0);
        int minutes = Math.max((int)(teamMission.getRemainingTime() % 3600L / 60L), 0);
        int hours = Math.max((int)(teamMission.getRemainingTime() / 3600L), 0);
        placeholders.add(new Placeholder("timeremaining_hours", String.valueOf(hours)));
        placeholders.add(new Placeholder("timeremaining_minutes", String.valueOf(minutes)));
        placeholders.add(new Placeholder("timeremaining_seconds", String.valueOf(seconds)));
        return ItemStackUtils.makeItem(missionData.getItem(), placeholders);
    }

    @Generated
    public MissionType getMissionType() {
        return this.missionType;
    }
}

