/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.SingleItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamWarp;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class WarpsGUI<T extends Team, U extends IridiumUser<T>>
extends BackGUI {
    private final T team;
    private final IridiumTeams<T, U> iridiumTeams;

    public WarpsGUI(T team, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().warpsGUI.background, player, iridiumTeams.getInventories().backButton);
        this.team = team;
        this.iridiumTeams = iridiumTeams;
    }

    @NotNull
    public Inventory getInventory() {
        SingleItemGUI noItemGUI = this.iridiumTeams.getInventories().warpsGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)noItemGUI.size, (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        AtomicInteger atomicInteger = new AtomicInteger(1);
        List<TeamWarp> teamWarps = this.iridiumTeams.getTeamManager().getTeamWarps(this.team);
        for (TeamWarp teamWarp : teamWarps) {
            int slot = this.iridiumTeams.getConfiguration().teamWarpSlots.get(atomicInteger.getAndIncrement());
            ItemStack itemStack = ItemStackUtils.makeItem(this.iridiumTeams.getInventories().warpsGUI.item, Arrays.asList(new Placeholder("island_name", ((Team)this.team).getName()), new Placeholder("warp_name", teamWarp.getName()), new Placeholder("warp_description", teamWarp.getDescription() != null ? teamWarp.getDescription() : ""), new Placeholder("warp_creator", Bukkit.getServer().getOfflinePlayer(teamWarp.getUser()).getName()), new Placeholder("warp_create_time", teamWarp.getCreateTime().format(DateTimeFormatter.ofPattern(this.iridiumTeams.getConfiguration().dateTimeFormat)))));
            Material material = teamWarp.getIcon().parseMaterial();
            if (material != null) {
                itemStack.setType(material);
            }
            inventory.setItem(slot, itemStack);
        }
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        List<TeamWarp> teamWarps = this.iridiumTeams.getTeamManager().getTeamWarps(this.team);
        for (Map.Entry<Integer, Integer> entrySet : this.iridiumTeams.getConfiguration().teamWarpSlots.entrySet()) {
            if (entrySet.getValue().intValue() != event.getSlot() || teamWarps.size() < entrySet.getKey()) continue;
            TeamWarp teamWarp = teamWarps.get(entrySet.getKey() - 1);
            switch (event.getClick()) {
                case LEFT: {
                    this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().warpCommand, new String[]{teamWarp.getName()});
                    return;
                }
                case RIGHT: {
                    this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().deleteWarpCommand, new String[]{teamWarp.getName()});
                }
            }
        }
    }
}

