/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.managers;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.InventoryUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankItem;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Shop;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ShopManager<T extends Team, U extends IridiumUser<T>> {
    private final IridiumTeams<T, U> iridiumTeams;

    public ShopManager(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }

    public void buy(Player player, Shop.ShopItem shopItem, int amount) {
        if (!this.canPurchase(player, shopItem, amount)) {
            this.iridiumTeams.getShop().failSound.play((Entity)player);
            return;
        }
        this.purchase(player, shopItem, amount);
        if (shopItem.command == null) {
            if (!this.iridiumTeams.getShop().dropItemWhenFull && !InventoryUtils.hasEmptySlot((Inventory)player.getInventory())) {
                player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().inventoryFull.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                return;
            }
            ItemStack itemStack = shopItem.type.parseItem();
            itemStack.setAmount(amount);
            for (ItemStack dropItem : player.getInventory().addItem(new ItemStack[]{itemStack}).values()) {
                player.getWorld().dropItem(player.getEyeLocation(), dropItem);
            }
        } else {
            String command = shopItem.command.replace("%player%", player.getName()).replace("%amount%", String.valueOf(amount));
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
        this.iridiumTeams.getShop().successSound.play((Entity)player);
        List<Placeholder> bankPlaceholders = this.iridiumTeams.getBankItemList().stream().map(BankItem::getName).map(name -> new Placeholder(name + "_cost", this.formatPrice(this.getBankBalance(player, (String)name)))).collect(Collectors.toList());
        double moneyCost = this.calculateCost(amount, shopItem.defaultAmount, shopItem.buyCost.money);
        player.sendMessage(StringUtils.color(StringUtils.processMultiplePlaceholders(this.iridiumTeams.getMessages().successfullyBought.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix).replace("%amount%", String.valueOf(amount)).replace("%item%", StringUtils.color(shopItem.name)).replace("%vault_cost%", this.formatPrice(moneyCost)), bankPlaceholders)));
    }

    public void sell(Player player, Shop.ShopItem shopItem, int amount) {
        int inventoryAmount = InventoryUtils.getAmount((Inventory)player.getInventory(), shopItem.type);
        if (inventoryAmount == 0) {
            player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().noSuchItem.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
            this.iridiumTeams.getShop().failSound.play((Entity)player);
            return;
        }
        int soldAmount = Math.min(inventoryAmount, amount);
        double moneyReward = this.calculateCost(soldAmount, shopItem.defaultAmount, shopItem.sellCost.money);
        InventoryUtils.removeAmount((Inventory)player.getInventory(), shopItem.type, soldAmount);
        this.iridiumTeams.getEconomy().depositPlayer((OfflinePlayer)player, moneyReward);
        player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().successfullySold.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix).replace("%amount%", String.valueOf(soldAmount)).replace("%item%", StringUtils.color(shopItem.name)).replace("%vault_reward%", String.valueOf(moneyReward))));
        this.iridiumTeams.getShop().successSound.play((Entity)player);
    }

    private double getBankBalance(Player player, String bankItem) {
        U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        return this.iridiumTeams.getTeamManager().getTeamViaID(((IridiumUser)user).getTeamID()).map(team -> this.iridiumTeams.getTeamManager().getTeamBank((Team)team, bankItem)).map(TeamBank::getNumber).orElse(0.0);
    }

    private void setBankBalance(Player player, String bankItem, double amount) {
        U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        Optional<T> team = this.iridiumTeams.getTeamManager().getTeamViaID(((IridiumUser)user).getTeamID());
        if (!team.isPresent()) {
            return;
        }
        this.iridiumTeams.getTeamManager().getTeamBank((Team)team.get(), bankItem).setNumber(amount);
    }

    private boolean canPurchase(Player player, Shop.ShopItem shopItem, int amount) {
        if (shopItem.minLevel > 1) {
            U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
            Optional<T> team = this.iridiumTeams.getTeamManager().getTeamViaID(((IridiumUser)user).getTeamID());
            if (!team.isPresent()) {
                player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().dontHaveTeam.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                return false;
            }
            if (((Team)team.get()).getLevel() < shopItem.minLevel) {
                player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().notHighEnoughLevel.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix).replace("%level%", String.valueOf(shopItem.minLevel))));
                return false;
            }
        }
        double moneyCost = this.calculateCost(amount, shopItem.defaultAmount, shopItem.buyCost.money);
        Economy economy = this.iridiumTeams.getEconomy();
        for (String bankItem : shopItem.buyCost.bankItems.keySet()) {
            double cost = this.calculateCost(amount, shopItem.defaultAmount, shopItem.buyCost.bankItems.get(bankItem));
            if (!(this.getBankBalance(player, bankItem) < cost)) continue;
            return false;
        }
        if (!(moneyCost == 0.0 || economy != null && economy.getBalance((OfflinePlayer)player) >= moneyCost)) {
            player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotAfford.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        return true;
    }

    private void purchase(Player player, Shop.ShopItem shopItem, int amount) {
        double moneyCost = this.calculateCost(amount, shopItem.defaultAmount, shopItem.buyCost.money);
        this.iridiumTeams.getEconomy().withdrawPlayer((OfflinePlayer)player, moneyCost);
        for (String bankItem : shopItem.buyCost.bankItems.keySet()) {
            double cost = this.calculateCost(amount, shopItem.defaultAmount, shopItem.buyCost.bankItems.get(bankItem));
            this.setBankBalance(player, bankItem, this.getBankBalance(player, bankItem) - cost);
        }
    }

    private double calculateCost(int amount, int defaultAmount, double defaultPrice) {
        double costPerItem = defaultPrice / (double)defaultAmount;
        return this.round(costPerItem * (double)amount, 2);
    }

    private double round(double value, int places) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        bigDecimal = bigDecimal.setScale(places, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public String formatPrice(double value) {
        if (this.iridiumTeams.getShop().abbreviatePrices) {
            return this.iridiumTeams.getConfiguration().numberFormatter.format(value);
        }
        return String.valueOf(value);
    }
}

