/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.managers;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.EssentialsSpawnSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.ObsidianStackerSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.RoseStackerSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.SpawnSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.SpawnerSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.StackerSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.WildStackerSupport;
import java.util.HashSet;
import lombok.Generated;
import org.bukkit.Bukkit;

public class SupportManager<T extends Team, U extends IridiumUser<T>> {
    private final IridiumTeams<T, U> iridiumTeams;
    private final HashSet<StackerSupport<T>> stackerSupport = new HashSet();
    private final HashSet<SpawnerSupport<T>> spawnerSupport = new HashSet();
    private final HashSet<SpawnSupport<T>> spawnSupport = new HashSet();
    private final HashSet<String> providerList = new HashSet();

    public SupportManager(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }

    public void registerDefaults() {
        this.registerBlockStackerSupport();
        this.registerSpawnerSupport();
        this.registerSpawnSupport();
    }

    public void registerBlockStackerSupport(StackerSupport<T> stackerSupport) {
        this.stackerSupport.add(stackerSupport);
        this.providerList.add(stackerSupport.supportProvider());
    }

    public void registerSpawnerSupport(SpawnerSupport<T> spawnerSupport) {
        this.spawnerSupport.add(spawnerSupport);
        this.providerList.add(spawnerSupport.supportProvider());
    }

    public void registerSpawnSupport(SpawnSupport<T> spawnSupport) {
        this.spawnSupport.add(spawnSupport);
        this.providerList.add(spawnSupport.supportProvider());
    }

    private void registerBlockStackerSupport() {
        if (this.isPluginEnabled("RoseStacker")) {
            this.registerBlockStackerSupport(new RoseStackerSupport<T, U>(this.iridiumTeams));
        }
        if (this.isPluginEnabled("WildStacker")) {
            this.registerBlockStackerSupport(new WildStackerSupport<T, U>(this.iridiumTeams));
        }
        if (this.isPluginEnabled("ObsidianStacker")) {
            this.registerBlockStackerSupport(new ObsidianStackerSupport<T, U>(this.iridiumTeams));
        }
    }

    private void registerSpawnerSupport() {
        if (this.isPluginEnabled("RoseStacker")) {
            this.registerSpawnerSupport(new RoseStackerSupport<T, U>(this.iridiumTeams));
        }
        if (this.isPluginEnabled("WildStacker")) {
            this.registerSpawnerSupport(new WildStackerSupport<T, U>(this.iridiumTeams));
        }
    }

    private void registerSpawnSupport() {
        if (this.isPluginEnabled("EssentialsSpawn")) {
            this.registerSpawnSupport(new EssentialsSpawnSupport<T, U>(this.iridiumTeams));
        }
    }

    private boolean isPluginEnabled(String pluginName) {
        return Bukkit.getPluginManager().isPluginEnabled(pluginName);
    }

    @Generated
    public HashSet<StackerSupport<T>> getStackerSupport() {
        return this.stackerSupport;
    }

    @Generated
    public HashSet<SpawnerSupport<T>> getSpawnerSupport() {
        return this.spawnerSupport;
    }

    @Generated
    public HashSet<SpawnSupport<T>> getSpawnSupport() {
        return this.spawnSupport;
    }

    @Generated
    public HashSet<String> getProviderList() {
        return this.providerList;
    }
}

