/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.support;

import com.bgsoftware.wildstacker.api.WildStackerAPI;
import com.bgsoftware.wildstacker.api.objects.StackedBarrel;
import com.bgsoftware.wildstacker.api.objects.StackedSpawner;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.SpawnerSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.StackerSupport;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;

public class WildStackerSupport<T extends Team, U extends IridiumUser<T>>
implements StackerSupport<T>,
SpawnerSupport<T> {
    private final IridiumTeams<T, U> iridiumTeams;

    public WildStackerSupport(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }

    @Override
    public String supportProvider() {
        return "WildStacker";
    }

    @Override
    public boolean isStackedBlock(Block block) {
        return WildStackerAPI.getWildStacker().getSystemManager().isStackedBarrel(block);
    }

    @Override
    public boolean isStackedSpawner(Block block) {
        return WildStackerAPI.getWildStacker().getSystemManager().isStackedSpawner(block);
    }

    private StackedBarrel getStackedBlock(Block block) {
        return WildStackerAPI.getWildStacker().getSystemManager().getStackedBarrel(block);
    }

    private StackedSpawner getStackedSpawner(Block block) {
        return WildStackerAPI.getWildStacker().getSystemManager().getStackedSpawner(block.getLocation());
    }

    private List<StackedBarrel> getStackedBarrels(List<Block> blocks) {
        ArrayList<StackedBarrel> stackedBarrels = new ArrayList<StackedBarrel>(Collections.emptyList());
        for (Block block : blocks) {
            stackedBarrels.add(this.getStackedBlock(block));
        }
        return stackedBarrels;
    }

    private List<StackedSpawner> getStackedSpawners(List<CreatureSpawner> spawners) {
        ArrayList<StackedSpawner> stackedSpawners = new ArrayList<StackedSpawner>(Collections.emptyList());
        for (CreatureSpawner spawner : spawners) {
            stackedSpawners.add(this.getStackedSpawner(spawner.getBlock()));
        }
        return stackedSpawners;
    }

    @Override
    public int getStackAmount(Block block) {
        return WildStackerAPI.getWildStacker().getSystemManager().getStackedBarrel(block).getStackAmount();
    }

    @Override
    public int getStackAmount(CreatureSpawner spawner) {
        return this.getStackedSpawner(spawner.getBlock()).getStackAmount();
    }

    @Override
    public int getSpawnAmount(CreatureSpawner spawner) {
        return this.getStackAmount(spawner) * WildStackerAPI.getWildStacker().getSystemManager().getStackedSpawner(spawner).getSpawner().getSpawnCount();
    }

    @Override
    public Map<XMaterial, Integer> getBlocksStacked(Chunk chunk, T team) {
        HashMap<XMaterial, Integer> hashMap = new HashMap<XMaterial, Integer>();
        WildStackerAPI.getWildStacker().getSystemManager().getStackedBarrels(chunk).forEach(stackedBarrel -> {
            if (!this.iridiumTeams.getTeamManager().isInTeam((Team)team, stackedBarrel.getLocation())) {
                return;
            }
            XMaterial xMaterial = XMaterial.matchXMaterial(stackedBarrel.getType());
            hashMap.put(xMaterial, hashMap.getOrDefault(xMaterial, 0) + stackedBarrel.getStackAmount());
        });
        return hashMap;
    }

    @Override
    public List<CreatureSpawner> getSpawnersStacked(Chunk chunk) {
        return WildStackerAPI.getWildStacker().getSystemManager().getStackedSpawners(chunk).stream().map(StackedSpawner::getSpawner).collect(Collectors.toList());
    }

    @Override
    public int getExtraBlocks(T team, XMaterial material, List<Block> blocks) {
        int stackedBlocks = 0;
        for (StackedBarrel stackedBarrel : this.getStackedBarrels(blocks)) {
            if (!this.iridiumTeams.getTeamManager().isInTeam(team, stackedBarrel.getLocation()) || material != XMaterial.matchXMaterial(stackedBarrel.getType())) continue;
            stackedBlocks += stackedBarrel.getStackAmount();
        }
        return stackedBlocks;
    }

    @Override
    public int getExtraSpawners(T team, EntityType entityType, List<CreatureSpawner> spawners) {
        int stackedSpawners = 0;
        for (StackedSpawner stackedSpawner : this.getStackedSpawners(spawners)) {
            if (!this.iridiumTeams.getTeamManager().isInTeam(team, stackedSpawner.getLocation()) || stackedSpawner.getSpawnedType() != entityType) continue;
            stackedSpawners += stackedSpawner.getStackAmount();
        }
        return stackedSpawners;
    }
}

