/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.ormlite.jdbc;

import com.iridium.iridiumskyblock.dependencies.ormlite.db.DatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.BaseJdbcConnectionSource;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.JdbcDatabaseConnection;
import com.iridium.iridiumskyblock.dependencies.ormlite.logger.Logger;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.ConnectionSource;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.DatabaseConnection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class JdbcConnectionSource
extends BaseJdbcConnectionSource
implements ConnectionSource {
    private String username;
    private String password;
    private Integer loginTimeoutSecs;

    public JdbcConnectionSource() {
    }

    public JdbcConnectionSource(String url) throws SQLException {
        this(url, null, null, null);
    }

    public JdbcConnectionSource(String url, DatabaseType databaseType) throws SQLException {
        this(url, null, null, databaseType);
    }

    public JdbcConnectionSource(String url, String username, String password) throws SQLException {
        this(url, username, password, null);
    }

    public JdbcConnectionSource(String url, String username, String password, DatabaseType databaseType) throws SQLException {
        super(url, databaseType, false);
        this.username = username;
        this.password = password;
        this.initialize();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLoginTimeoutSecs(Integer loginTimeoutSecs) {
        this.loginTimeoutSecs = loginTimeoutSecs;
    }

    @Override
    protected DatabaseConnection makeConnection(Logger logger) throws SQLException {
        Properties properties = new Properties();
        if (this.username != null) {
            properties.setProperty("user", this.username);
        }
        if (this.password != null) {
            properties.setProperty("password", this.password);
        }
        if (this.loginTimeoutSecs != null) {
            DriverManager.setLoginTimeout(this.loginTimeoutSecs);
        }
        JdbcDatabaseConnection connection = new JdbcDatabaseConnection(DriverManager.getConnection(this.url, properties));
        connection.setAutoCommit(true);
        logger.debug("opened connection to {} got #{}", (Object)this.url, (Object)connection.hashCode());
        return connection;
    }
}

