/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.ormlite.table;

import com.iridium.iridiumskyblock.dependencies.ormlite.db.DatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DatabaseField;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DatabaseFieldConfig;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.FieldType;
import com.iridium.iridiumskyblock.dependencies.ormlite.misc.JavaxPersistenceConfigurer;
import com.iridium.iridiumskyblock.dependencies.ormlite.table.DatabaseTable;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DatabaseTableConfig<T> {
    private static JavaxPersistenceConfigurer javaxPersistenceConfigurer;
    private DatabaseType databaseType;
    private Class<T> dataClass;
    private String tableName;
    private String schemaName;
    private List<DatabaseFieldConfig> fieldConfigs;
    private FieldType[] fieldTypes;

    public DatabaseTableConfig() {
    }

    public DatabaseTableConfig(DatabaseType databaseType, Class<T> dataClass, List<DatabaseFieldConfig> fieldConfigs) {
        this(dataClass, DatabaseTableConfig.extractSchemaName(dataClass), DatabaseTableConfig.extractTableName(databaseType, dataClass), fieldConfigs);
    }

    public DatabaseTableConfig(Class<T> dataClass, String tableName, List<DatabaseFieldConfig> fieldConfigs) {
        this.dataClass = dataClass;
        this.schemaName = null;
        this.tableName = tableName;
        this.fieldConfigs = fieldConfigs;
    }

    public DatabaseTableConfig(Class<T> dataClass, String schemaName, String tableName, List<DatabaseFieldConfig> fieldConfigs) {
        this.dataClass = dataClass;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.fieldConfigs = fieldConfigs;
    }

    private DatabaseTableConfig(DatabaseType databaseType, Class<T> dataClass, String schemaName, String tableName, FieldType[] fieldTypes) {
        this.databaseType = databaseType;
        this.dataClass = dataClass;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.fieldTypes = fieldTypes;
    }

    public void initialize() {
        if (this.dataClass == null) {
            throw new IllegalStateException("dataClass was never set on " + this.getClass().getSimpleName());
        }
        if (this.tableName == null) {
            this.tableName = DatabaseTableConfig.extractTableName(this.databaseType, this.dataClass);
        }
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(Class<T> dataClass) {
        this.dataClass = dataClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setFieldConfigs(List<DatabaseFieldConfig> fieldConfigs) {
        this.fieldConfigs = fieldConfigs;
    }

    public void extractFieldTypes(DatabaseType databaseType) throws SQLException {
        if (this.fieldTypes == null) {
            this.fieldTypes = this.fieldConfigs == null ? DatabaseTableConfig.extractFieldTypes(databaseType, this.dataClass, this.tableName) : this.convertFieldConfigs(databaseType, this.tableName, this.fieldConfigs);
        }
    }

    public FieldType[] getFieldTypes(DatabaseType databaseType) throws SQLException {
        if (this.fieldTypes == null) {
            throw new SQLException("Field types have not been extracted in table config");
        }
        return this.fieldTypes;
    }

    public List<DatabaseFieldConfig> getFieldConfigs() {
        return this.fieldConfigs;
    }

    public static <T> DatabaseTableConfig<T> fromClass(DatabaseType databaseType, Class<T> clazz) throws SQLException {
        String tableName = DatabaseTableConfig.extractTableName(databaseType, clazz);
        String schemaName = DatabaseTableConfig.extractSchemaName(clazz);
        if (databaseType.isEntityNamesMustBeUpCase()) {
            tableName = databaseType.upCaseEntityName(tableName);
            if (schemaName != null) {
                schemaName = databaseType.upCaseEntityName(schemaName);
            }
        }
        return new DatabaseTableConfig<T>(databaseType, clazz, schemaName, tableName, DatabaseTableConfig.extractFieldTypes(databaseType, clazz, tableName));
    }

    public static <T> String extractTableName(DatabaseType databaseType, Class<T> clazz) {
        DatabaseTable databaseTable = clazz.getAnnotation(DatabaseTable.class);
        String name = null;
        if (databaseTable != null && databaseTable.tableName() != null && databaseTable.tableName().length() > 0) {
            name = databaseTable.tableName();
        }
        if (name == null && javaxPersistenceConfigurer != null) {
            name = javaxPersistenceConfigurer.getEntityName(clazz);
        }
        if (name == null) {
            name = databaseType == null ? clazz.getSimpleName().toLowerCase(Locale.ENGLISH) : databaseType.downCaseString(clazz.getSimpleName(), true);
        }
        return name;
    }

    public static <T> String extractSchemaName(Class<T> clazz) {
        DatabaseTable databaseTable = clazz.getAnnotation(DatabaseTable.class);
        if (databaseTable != null && databaseTable.schemaName().length() > 0) {
            return databaseTable.schemaName();
        }
        return null;
    }

    private static <T> FieldType[] extractFieldTypes(DatabaseType databaseType, Class<T> clazz, String tableName) throws SQLException {
        ArrayList<FieldType> fieldTypes = new ArrayList<FieldType>();
        for (Class<T> classWalk = clazz; classWalk != null; classWalk = classWalk.getSuperclass()) {
            for (Field field : classWalk.getDeclaredFields()) {
                FieldType fieldType = FieldType.createFieldType(databaseType, tableName, field, clazz);
                if (fieldType == null) continue;
                fieldTypes.add(fieldType);
            }
        }
        if (fieldTypes.isEmpty()) {
            throw new IllegalArgumentException("No fields have a " + DatabaseField.class.getSimpleName() + " annotation in " + clazz);
        }
        return fieldTypes.toArray(new FieldType[fieldTypes.size()]);
    }

    private FieldType[] convertFieldConfigs(DatabaseType databaseType, String tableName, List<DatabaseFieldConfig> fieldConfigs) throws SQLException {
        ArrayList<FieldType> fieldTypes = new ArrayList<FieldType>();
        for (DatabaseFieldConfig fieldConfig : fieldConfigs) {
            FieldType fieldType = null;
            for (Class<T> classWalk = this.dataClass; classWalk != null; classWalk = classWalk.getSuperclass()) {
                Field field;
                try {
                    field = classWalk.getDeclaredField(fieldConfig.getFieldName());
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                if (field == null) continue;
                fieldType = new FieldType(databaseType, tableName, field, fieldConfig, this.dataClass);
                break;
            }
            if (fieldType == null) {
                throw new SQLException("Could not find declared field with name '" + fieldConfig.getFieldName() + "' for " + this.dataClass);
            }
            fieldTypes.add(fieldType);
        }
        if (fieldTypes.isEmpty()) {
            throw new SQLException("No fields were configured for class " + this.dataClass);
        }
        return fieldTypes.toArray(new FieldType[fieldTypes.size()]);
    }

    static {
        try {
            Class.forName("javax.persistence.Entity");
            Class<?> clazz = Class.forName("com.iridium.iridiumskyblock.dependencies.ormlite.misc.JavaxPersistenceImpl");
            javaxPersistenceConfigurer = (JavaxPersistenceConfigurer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            javaxPersistenceConfigurer = null;
        }
    }
}

