/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.generators;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.configs.Generators;
import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import com.iridium.iridiumskyblock.utils.LocationUtils;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public class OceanGenerator
extends ChunkGenerator {
    @NotNull
    public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.BiomeGrid biomeGrid) {
        SimplexOctaveGenerator generator = new SimplexOctaveGenerator(new Random(world.getSeed()), 8);
        ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
        generator.setScale(0.005);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int currentFloorHeight = (int)((generator.noise((double)(chunkX * 16 + x), (double)(chunkZ * 16 + z), 1.5, 0.5, true) + 1.0) * (double)(this.getOceanGenerator((World.Environment)world.getEnvironment()).maxFloorHeight - this.getOceanGenerator((World.Environment)world.getEnvironment()).minFloorHeight) + (double)this.getOceanGenerator((World.Environment)world.getEnvironment()).minFloorHeight);
                chunkData.setBlock(x, LocationUtils.getMinHeight(world), z, Objects.requireNonNull(XMaterial.BEDROCK.parseMaterial()));
                for (y = LocationUtils.getMinHeight(world) + 1; y < currentFloorHeight; ++y) {
                    chunkData.setBlock(x, y, z, Objects.requireNonNull(this.getOceanGenerator((World.Environment)world.getEnvironment()).underFloor.parseMaterial()));
                }
                chunkData.setBlock(x, currentFloorHeight, z, Objects.requireNonNull(this.getOceanGenerator((World.Environment)world.getEnvironment()).floor.parseMaterial()));
                for (y = currentFloorHeight + 1; y <= this.getOceanGenerator((World.Environment)world.getEnvironment()).liquidHeight; ++y) {
                    chunkData.setBlock(x, y, z, Objects.requireNonNull(this.getOceanGenerator((World.Environment)world.getEnvironment()).liquidType.parseMaterial()));
                }
                biomeGrid.setBiome(x, z, Objects.requireNonNull(this.getOceanGenerator((World.Environment)world.getEnvironment()).biome.getBiome()));
            }
        }
        return chunkData;
    }

    public void generateOcean(World world, int x, int z) {
        Block block;
        int y;
        Random random = new Random(world.getSeed());
        SimplexOctaveGenerator generator = new SimplexOctaveGenerator(random, 8);
        generator.setScale(0.005);
        int currentFloorHeight = (int)((generator.noise((double)x, (double)z, 1.5, 0.5, true) + 1.0) * (double)(this.getOceanGenerator((World.Environment)world.getEnvironment()).maxFloorHeight - this.getOceanGenerator((World.Environment)world.getEnvironment()).minFloorHeight) + (double)this.getOceanGenerator((World.Environment)world.getEnvironment()).minFloorHeight);
        int minHeightWorld = LocationUtils.getMinHeight(world);
        if (world.getBlockAt(x, minHeightWorld, z).getType() != XMaterial.BEDROCK.parseMaterial()) {
            if (world.getBlockAt(x, minHeightWorld, z).getState() instanceof InventoryHolder) {
                ((InventoryHolder)world.getBlockAt(x, minHeightWorld, z).getState()).getInventory().clear();
            }
            world.getBlockAt(x, minHeightWorld, z).setType(Material.BEDROCK, false);
        }
        for (y = minHeightWorld + 1; y < currentFloorHeight; ++y) {
            block = world.getBlockAt(x, y, z);
            if (block.getType() == this.getOceanGenerator((World.Environment)world.getEnvironment()).underFloor.parseMaterial() || this.getOceanGenerator((World.Environment)world.getEnvironment()).underFloor.parseMaterial() == null) continue;
            if (block.getState() instanceof InventoryHolder) {
                ((InventoryHolder)block.getState()).getInventory().clear();
            }
            block.setType(Objects.requireNonNull(this.getOceanGenerator((World.Environment)world.getEnvironment()).underFloor.parseMaterial()), false);
        }
        if (world.getBlockAt(x, currentFloorHeight, z).getType() != this.getOceanGenerator((World.Environment)world.getEnvironment()).floor.parseMaterial() && this.getOceanGenerator((World.Environment)world.getEnvironment()).floor.parseMaterial() != null) {
            if (world.getBlockAt(x, currentFloorHeight, z).getState() instanceof InventoryHolder) {
                ((InventoryHolder)world.getBlockAt(x, currentFloorHeight, z).getState()).getInventory().clear();
            }
            for (y = currentFloorHeight; y < currentFloorHeight + 5; ++y) {
                world.getBlockAt(x, currentFloorHeight, z).setType(Objects.requireNonNull(this.getOceanGenerator((World.Environment)world.getEnvironment()).floor.parseMaterial()), false);
                ++currentFloorHeight;
            }
        }
        for (y = currentFloorHeight + 1; y <= this.getOceanGenerator((World.Environment)world.getEnvironment()).liquidHeight; ++y) {
            block = world.getBlockAt(x, y, z);
            if (block.getType() == this.getOceanGenerator((World.Environment)world.getEnvironment()).liquidType.parseMaterial() || this.getOceanGenerator((World.Environment)world.getEnvironment()).liquidType.parseMaterial() == null) continue;
            if (block.getState() instanceof InventoryHolder) {
                ((InventoryHolder)block.getState()).getInventory().clear();
            }
            block.setType(this.getOceanGenerator((World.Environment)world.getEnvironment()).liquidType.parseMaterial(), false);
        }
        for (y = this.getOceanGenerator((World.Environment)world.getEnvironment()).liquidHeight + 1; y < world.getMaxHeight(); ++y) {
            block = world.getBlockAt(x, y, z);
            if (block.getType() == Material.AIR) continue;
            if (block.getState() instanceof InventoryHolder) {
                ((InventoryHolder)block.getState()).getInventory().clear();
            }
            block.setType(Material.AIR, false);
        }
    }

    public boolean shouldGenerateDecorations(@NotNull WorldInfo worldInfo, @NotNull Random random, int x, int z) {
        return this.getOceanGenerator((World.Environment)worldInfo.getEnvironment()).decorate;
    }

    public boolean canSpawn(@NotNull World world, int x, int z) {
        return this.getOceanGenerator((World.Environment)world.getEnvironment()).canSpawnEntities;
    }

    private Generators.OceanGeneratorWorld getOceanGenerator(World.Environment environment) {
        switch (environment) {
            case NETHER: {
                return IridiumSkyblock.getInstance().getGenerators().oceanGenerator.nether;
            }
            case THE_END: {
                return IridiumSkyblock.getInstance().getGenerators().oceanGenerator.end;
            }
        }
        return IridiumSkyblock.getInstance().getGenerators().oceanGenerator.overworld;
    }
}

