/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.generators;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.configs.Generators;
import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.bukkit.World;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;

public class VoidGenerator
extends ChunkGenerator {
    public byte[][] blockSections;

    @NotNull
    public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.BiomeGrid biomeGrid) {
        ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                biomeGrid.setBiome(x, z, Objects.requireNonNull(this.getSkyblockGenerator((World.Environment)world.getEnvironment()).biome.getBiome()));
            }
        }
        return chunkData;
    }

    public byte[][] generateBlockSections(World world, Random random, int x, int z, ChunkGenerator.BiomeGrid biomeGrid) {
        if (this.blockSections == null) {
            this.blockSections = new byte[world.getMaxHeight() / 16][];
        }
        return this.blockSections;
    }

    public boolean canSpawn(@NotNull World world, int x, int z) {
        return this.getSkyblockGenerator((World.Environment)world.getEnvironment()).canSpawnEntities;
    }

    @NotNull
    public List<BlockPopulator> getDefaultPopulators(@NotNull World world) {
        return Collections.emptyList();
    }

    private Generators.SkyblockGeneratorWorld getSkyblockGenerator(World.Environment environment) {
        switch (environment) {
            case NETHER: {
                return IridiumSkyblock.getInstance().getGenerators().skyblockGenerator.nether;
            }
            case THE_END: {
                return IridiumSkyblock.getInstance().getGenerators().skyblockGenerator.end;
            }
        }
        return IridiumSkyblock.getInstance().getGenerators().skyblockGenerator.overworld;
    }
}

