/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.gui;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.configs.Biomes;
import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.NoItemGUI;
import com.iridium.iridiumskyblock.gui.BiomeCategoryGUI;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class BiomeOverviewGUI
extends BackGUI {
    public BiomeOverviewGUI(Player player) {
        super(IridiumSkyblock.getInstance().getInventories().biomeOverviewGUI.background, player, IridiumSkyblock.getInstance().getInventories().backButton);
    }

    @NotNull
    public Inventory getInventory() {
        NoItemGUI biomeOverviewGUI = IridiumSkyblock.getInstance().getInventories().biomeOverviewGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)biomeOverviewGUI.size, (String)StringUtils.color(biomeOverviewGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        for (Biomes.BiomeCategory category : IridiumSkyblock.getInstance().getBiomes().categories.values()) {
            inventory.setItem(category.item.slot.intValue(), ItemStackUtils.makeItem(category.item));
        }
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        for (Map.Entry<String, Biomes.BiomeCategory> category : IridiumSkyblock.getInstance().getBiomes().categories.entrySet()) {
            if (event.getSlot() != category.getValue().item.slot.intValue()) continue;
            event.getWhoClicked().openInventory(new BiomeCategoryGUI(category.getKey(), (Player)event.getWhoClicked()).getInventory());
            return;
        }
        super.onInventoryClick(event);
    }
}

