/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.managers;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.configs.SQL;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.database.LostItems;
import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBlock;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamEnhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamInvite;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamLog;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamMission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamMissionData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamPermission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamReward;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSpawners;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamTrust;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamWarp;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.types.InventoryType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.types.LocalDateTimeType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.types.LocationType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.types.RewardType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.types.XBiomeType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.types.XEnchantmentType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.types.XEntityTypeType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.types.XMaterialType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.types.XPotionType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DataPersisterManager;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.JdbcConnectionSource;
import com.iridium.iridiumskyblock.dependencies.ormlite.jdbc.db.DatabaseTypeUtils;
import com.iridium.iridiumskyblock.dependencies.ormlite.logger.LoggerFactory;
import com.iridium.iridiumskyblock.dependencies.ormlite.logger.NullLogBackend;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.ConnectionSource;
import com.iridium.iridiumskyblock.managers.tablemanagers.ForeignIslandTableManager;
import com.iridium.iridiumskyblock.managers.tablemanagers.IslandTableManager;
import com.iridium.iridiumskyblock.managers.tablemanagers.LostItemsTableManager;
import com.iridium.iridiumskyblock.managers.tablemanagers.SqlTableManager;
import com.iridium.iridiumskyblock.managers.tablemanagers.TableManager;
import com.iridium.iridiumskyblock.managers.tablemanagers.UserTableManager;
import java.io.File;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class DatabaseManager {
    private ConnectionSource connectionSource;
    private UserTableManager userTableManager;
    private IslandTableManager islandTableManager;
    private LostItemsTableManager lostItemsTableManager;
    private TableManager<String, TeamMissionData, Integer> teamMissionDataTableManager;
    private ForeignIslandTableManager<String, TeamInvite> invitesTableManager;
    private ForeignIslandTableManager<String, TeamTrust> trustTableManager;
    private ForeignIslandTableManager<String, TeamPermission> permissionsTableManager;
    private ForeignIslandTableManager<String, TeamBank> bankTableManager;
    private ForeignIslandTableManager<String, TeamEnhancement> enhancementTableManager;
    private ForeignIslandTableManager<String, TeamBlock> teamBlockTableManager;
    private ForeignIslandTableManager<String, TeamSpawners> teamSpawnerTableManager;
    private ForeignIslandTableManager<String, TeamWarp> teamWarpTableManager;
    private ForeignIslandTableManager<String, TeamMission> teamMissionTableManager;
    private ForeignIslandTableManager<String, TeamReward> teamRewardsTableManager;
    private ForeignIslandTableManager<String, TeamSetting> teamSettingsTableManager;
    private SqlTableManager<TeamLog, Integer> teamLogsTableManager;

    public void init() throws SQLException {
        LoggerFactory.setLogBackendFactory(new NullLogBackend.NullLogBackendFactory());
        SQL sqlConfig = IridiumSkyblock.getInstance().getSql();
        String databaseURL = this.getDatabaseURL(sqlConfig);
        DataPersisterManager.registerDataPersisters(XMaterialType.getSingleton());
        DataPersisterManager.registerDataPersisters(XEntityTypeType.getSingleton());
        DataPersisterManager.registerDataPersisters(XPotionType.getSingleton());
        DataPersisterManager.registerDataPersisters(XEnchantmentType.getSingleton());
        DataPersisterManager.registerDataPersisters(XBiomeType.getSingleton());
        DataPersisterManager.registerDataPersisters(LocationType.getSingleton());
        DataPersisterManager.registerDataPersisters(InventoryType.getSingleton());
        DataPersisterManager.registerDataPersisters(LocalDateTimeType.getSingleton());
        DataPersisterManager.registerDataPersisters(RewardType.getSingleton(IridiumSkyblock.getInstance()));
        this.connectionSource = new JdbcConnectionSource(databaseURL, sqlConfig.username, sqlConfig.password, DatabaseTypeUtils.createDatabaseType(databaseURL));
        this.userTableManager = new UserTableManager(this.connectionSource);
        this.islandTableManager = new IslandTableManager(this.connectionSource);
        this.lostItemsTableManager = new LostItemsTableManager(this.connectionSource, LostItems.class);
        this.teamMissionDataTableManager = new TableManager(teamMissionData -> this.getDatabaseKey(teamMissionData.getMissionID(), teamMissionData.getMissionIndex()), this.connectionSource, TeamMissionData.class);
        this.invitesTableManager = new ForeignIslandTableManager<String, TeamInvite>(teamInvite -> this.getDatabaseKey(teamInvite.getTeamID(), teamInvite.getUser()), this.connectionSource, TeamInvite.class);
        this.trustTableManager = new ForeignIslandTableManager<String, TeamTrust>(teamTrust -> this.getDatabaseKey(teamTrust.getTeamID(), teamTrust.getUser()), this.connectionSource, TeamTrust.class);
        this.permissionsTableManager = new ForeignIslandTableManager<String, TeamPermission>(teamPermission -> this.getDatabaseKey(teamPermission.getTeamID(), teamPermission.getPermission(), teamPermission.getRank()), this.connectionSource, TeamPermission.class);
        this.bankTableManager = new ForeignIslandTableManager<String, TeamBank>(teamBank -> this.getDatabaseKey(teamBank.getTeamID(), teamBank.getBankItem()), this.connectionSource, TeamBank.class);
        this.enhancementTableManager = new ForeignIslandTableManager<String, TeamEnhancement>(teamEnhancement -> this.getDatabaseKey(teamEnhancement.getTeamID(), teamEnhancement.getEnhancementName()), this.connectionSource, TeamEnhancement.class);
        this.teamBlockTableManager = new ForeignIslandTableManager<String, TeamBlock>(teamBlock -> this.getDatabaseKey(teamBlock.getTeamID(), teamBlock.getXMaterial().name()), this.connectionSource, TeamBlock.class);
        this.teamSpawnerTableManager = new ForeignIslandTableManager<String, TeamSpawners>(teamSpawner -> this.getDatabaseKey(teamSpawner.getTeamID(), teamSpawner.getEntityType().name()), this.connectionSource, TeamSpawners.class);
        this.teamWarpTableManager = new ForeignIslandTableManager<String, TeamWarp>(teamWarp -> this.getDatabaseKey(teamWarp.getTeamID(), teamWarp.getName()), this.connectionSource, TeamWarp.class);
        this.teamMissionTableManager = new ForeignIslandTableManager<String, TeamMission>(teamMission -> this.getDatabaseKey(teamMission.getTeamID(), teamMission.getMissionName()), this.connectionSource, TeamMission.class);
        this.teamRewardsTableManager = new ForeignIslandTableManager<String, TeamReward>(teamRewards -> this.getDatabaseKey(teamRewards.getId()), this.connectionSource, TeamReward.class);
        this.teamSettingsTableManager = new ForeignIslandTableManager<String, TeamSetting>(teamSetting -> this.getDatabaseKey(teamSetting.getTeamID(), teamSetting.getSetting()), this.connectionSource, TeamSetting.class);
        this.teamLogsTableManager = new SqlTableManager(this.connectionSource, TeamLog.class);
    }

    private String getDatabaseKey(Object ... params) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : params) {
            stringBuilder.append(obj);
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    @NotNull
    private String getDatabaseURL(SQL sqlConfig) {
        switch (sqlConfig.driver) {
            case MYSQL: {
                return "jdbc:" + sqlConfig.driver.name().toLowerCase() + "://" + sqlConfig.host + ":" + sqlConfig.port + "/" + sqlConfig.database + "?useSSL=" + sqlConfig.useSSL;
            }
            case SQLITE: {
                return "jdbc:sqlite:" + new File(IridiumSkyblock.getInstance().getDataFolder(), sqlConfig.database + ".db");
            }
        }
        throw new UnsupportedOperationException("Unsupported driver (how did we get here?): " + sqlConfig.driver.name());
    }

    public CompletableFuture<Void> registerIsland(Island island) {
        return CompletableFuture.runAsync(() -> {
            this.islandTableManager.save(island);
            this.islandTableManager.addEntry(island);
        });
    }

    @Generated
    public UserTableManager getUserTableManager() {
        return this.userTableManager;
    }

    @Generated
    public IslandTableManager getIslandTableManager() {
        return this.islandTableManager;
    }

    @Generated
    public LostItemsTableManager getLostItemsTableManager() {
        return this.lostItemsTableManager;
    }

    @Generated
    public TableManager<String, TeamMissionData, Integer> getTeamMissionDataTableManager() {
        return this.teamMissionDataTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamInvite> getInvitesTableManager() {
        return this.invitesTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamTrust> getTrustTableManager() {
        return this.trustTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamPermission> getPermissionsTableManager() {
        return this.permissionsTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamBank> getBankTableManager() {
        return this.bankTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamEnhancement> getEnhancementTableManager() {
        return this.enhancementTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamBlock> getTeamBlockTableManager() {
        return this.teamBlockTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamSpawners> getTeamSpawnerTableManager() {
        return this.teamSpawnerTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamWarp> getTeamWarpTableManager() {
        return this.teamWarpTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamMission> getTeamMissionTableManager() {
        return this.teamMissionTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamReward> getTeamRewardsTableManager() {
        return this.teamRewardsTableManager;
    }

    @Generated
    public ForeignIslandTableManager<String, TeamSetting> getTeamSettingsTableManager() {
        return this.teamSettingsTableManager;
    }

    @Generated
    public SqlTableManager<TeamLog, Integer> getTeamLogsTableManager() {
        return this.teamLogsTableManager;
    }
}

