/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.managers.tablemanagers;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.dependencies.ormlite.dao.Dao;
import com.iridium.iridiumskyblock.dependencies.ormlite.dao.DaoManager;
import com.iridium.iridiumskyblock.dependencies.ormlite.stmt.PreparedQuery;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.ConnectionSource;
import com.iridium.iridiumskyblock.dependencies.ormlite.table.TableUtils;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;

public class SqlTableManager<Value, ID> {
    private final Dao<Value, ID> dao;
    private final Lock lock = new ReentrantLock();

    public SqlTableManager(ConnectionSource connectionSource, Class<Value> clazz) throws SQLException {
        this.dao = DaoManager.createDao(connectionSource, clazz);
        TableUtils.createTableIfNotExists(connectionSource, clazz);
    }

    public void save(Value value) {
        try {
            if (!this.lock.tryLock(5L, TimeUnit.SECONDS)) {
                IridiumSkyblock.getInstance().getLogger().warning("Warning: Failed to acquire lock within 5 seconds in save(value)");
                return;
            }
            try {
                this.dao.createOrUpdate(value);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Value> query(PreparedQuery<Value> preparedQuery) {
        try {
            return this.dao.query(preparedQuery);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Generated
    public Dao<Value, ID> getDao() {
        return this.dao;
    }
}

