/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.managers.tablemanagers;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.DatabaseObject;
import com.iridium.iridiumskyblock.dependencies.ormlite.dao.Dao;
import com.iridium.iridiumskyblock.dependencies.ormlite.dao.DaoManager;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.ConnectionSource;
import com.iridium.iridiumskyblock.dependencies.ormlite.support.DatabaseConnection;
import com.iridium.iridiumskyblock.dependencies.ormlite.table.TableUtils;
import com.iridium.iridiumskyblock.managers.DatabaseKey;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TableManager<Key, Value extends DatabaseObject, ID> {
    private final ConcurrentHashMap<Key, Value> entries = new ConcurrentHashMap();
    private final Dao<Value, ID> dao;
    private final DatabaseKey<Key, Value> databaseKey;
    private static final Lock lock = new ReentrantLock();
    private final ConnectionSource connectionSource;

    public TableManager(DatabaseKey<Key, Value> databaseKey, ConnectionSource connectionSource, Class<Value> clazz) throws SQLException {
        this.connectionSource = connectionSource;
        this.databaseKey = databaseKey;
        this.dao = DaoManager.createDao(connectionSource, clazz);
        this.dao.setAutoCommit(this.getDatabaseConnection(), false);
        TableUtils.createTableIfNotExists(connectionSource, clazz);
        this.dao.queryForAll().forEach(this::addEntry);
        this.getEntries().forEach(value -> value.setChanged(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            if (!lock.tryLock(5L, TimeUnit.SECONDS)) {
                IridiumSkyblock.getInstance().getLogger().warning("Warning: Lock acquisition took more than 5 second in save() method.");
            }
            try {
                ArrayList<Value> entryList = new ArrayList<Value>(this.entries.values());
                boolean modified = false;
                for (DatabaseObject t : entryList) {
                    if (!t.isChanged()) continue;
                    modified = true;
                    this.dao.createOrUpdate(t);
                    t.setChanged(false);
                }
                if (modified) {
                    this.dao.commit(this.getDatabaseConnection());
                }
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(Value value) {
        try {
            if (!lock.tryLock(5L, TimeUnit.SECONDS)) {
                IridiumSkyblock.getInstance().getLogger().warning("Warning: Lock acquisition took more than 5 second in save(value) method.");
            }
            try {
                if (!((DatabaseObject)value).isChanged()) {
                    return;
                }
                this.dao.createOrUpdate(value);
                this.dao.commit(this.getDatabaseConnection());
                ((DatabaseObject)value).setChanged(false);
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompletableFuture<Void> delete(Value value) {
        this.entries.remove(this.databaseKey.getKey(value));
        return CompletableFuture.runAsync(() -> {
            try {
                if (!lock.tryLock(5L, TimeUnit.SECONDS)) {
                    IridiumSkyblock.getInstance().getLogger().warning("Warning: Lock acquisition took more than 5 second in delete(value) method.");
                }
                try {
                    this.dao.delete(value);
                    this.dao.commit(this.getDatabaseConnection());
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public CompletableFuture<Void> delete(Collection<Value> values) {
        values.forEach(value -> this.entries.remove(this.databaseKey.getKey((DatabaseObject)value)));
        return CompletableFuture.runAsync(() -> {
            try {
                if (!lock.tryLock(5L, TimeUnit.SECONDS)) {
                    IridiumSkyblock.getInstance().getLogger().warning("Warning: Lock acquisition took more than 5 second in delete(Collection<value>) method.");
                }
                try {
                    this.dao.delete(values);
                    this.dao.commit(this.getDatabaseConnection());
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void addEntry(Value value) {
        try {
            this.entries.put(this.databaseKey.getKey(value), value);
        }
        catch (Exception e) {
            IridiumSkyblock.getInstance().getLogger().warning("Warning: Deleting " + value.getClass().getName() + " record because " + e.getMessage());
            CompletableFuture.runAsync(() -> {
                try {
                    if (!lock.tryLock(5L, TimeUnit.SECONDS)) {
                        IridiumSkyblock.getInstance().getLogger().warning("Warning: Lock acquisition took more than 5 second in delete(value) method.");
                    }
                    try {
                        this.dao.delete(value);
                        this.dao.commit(this.getDatabaseConnection());
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            });
        }
    }

    public List<Value> getEntries(Function<? super Value, Boolean> searchFunction) {
        return this.entries.values().stream().filter(searchFunction::apply).collect(Collectors.toList());
    }

    public List<Value> getEntries() {
        return new ArrayList<Value>(this.entries.values());
    }

    public Optional<Value> getEntry(Key key) {
        if (key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((DatabaseObject)this.entries.get(key));
    }

    public Optional<Value> getEntry(Value value) {
        return this.getEntry((Value)this.databaseKey.getKey(value));
    }

    public Optional<Value> getEntry(Function<? super Value, Boolean> searchFunction) {
        return this.entries.values().stream().filter(searchFunction::apply).findFirst();
    }

    private DatabaseConnection getDatabaseConnection() throws SQLException {
        return this.connectionSource.getReadWriteConnection(null);
    }
}

