/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.placeholders;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.database.User;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PlaceholderBuilder;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Rank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.TemporaryCache;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankItem;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamEnhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.Enhancement;
import com.iridium.iridiumskyblock.dependencies.xseries.XEntityType;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class IslandPlaceholderBuilder
implements PlaceholderBuilder<Island> {
    private final TemporaryCache<Island, List<Placeholder>> cache = new TemporaryCache();
    private final List<Placeholder> defaultPlaceholders = this.initializeDefaultPlaceholders();

    @Override
    public List<Placeholder> getPlaceholders(Island island) {
        return this.cache.get(island, Duration.ofSeconds(1L), () -> {
            List users = IridiumSkyblock.getInstance().getTeamManager().getTeamMembers(island);
            ArrayList onlineUsers = new ArrayList(Collections.emptyList());
            ArrayList offlineUsers = new ArrayList(Collections.emptyList());
            for (User user : users) {
                if (user.getPlayer() != null) {
                    onlineUsers.add(user.getName());
                    continue;
                }
                offlineUsers.add(user.getName());
            }
            Placeholder[] placeholderArray = new Placeholder[16];
            placeholderArray[0] = new Placeholder("island_name", island::getName);
            placeholderArray[1] = new Placeholder("island_owner", () -> IridiumSkyblock.getInstance().getTeamManager().getTeamMembers(island).stream().filter(user -> user.getUserRank() == Rank.OWNER.getId()).findFirst().map(IridiumUser::getName).orElse(IridiumSkyblock.getInstance().getMessages().nullPlaceholder));
            placeholderArray[2] = new Placeholder("island_create", () -> island.getCreateTime().format(DateTimeFormatter.ofPattern(IridiumSkyblock.getInstance().getConfiguration().dateTimeFormat)));
            placeholderArray[3] = new Placeholder("island_description", island::getDescription);
            placeholderArray[4] = new Placeholder("island_value", () -> this.formatDouble(IridiumSkyblock.getInstance().getTeamManager().getTeamValue(island)));
            placeholderArray[5] = new Placeholder("island_level", () -> String.valueOf(island.getLevel()));
            placeholderArray[6] = new Placeholder("island_experience", String.valueOf(island.getExperience()));
            placeholderArray[7] = new Placeholder("island_experienceToLevelUp", String.valueOf(IridiumSkyblock.getInstance().getIslandManager().getTeamExperienceForNextLevel(island)));
            placeholderArray[8] = new Placeholder("island_experienceForNextLevel", String.valueOf(IridiumSkyblock.getInstance().getIslandManager().getExperienceForLevel(island.getLevel() + 1)));
            placeholderArray[9] = new Placeholder("island_value_rank", () -> String.valueOf(IridiumSkyblock.getInstance().getIslandManager().getRank(island, IridiumSkyblock.getInstance().getTop().valueTeamSort)));
            placeholderArray[10] = new Placeholder("island_experience_rank", () -> String.valueOf(IridiumSkyblock.getInstance().getIslandManager().getRank(island, IridiumSkyblock.getInstance().getTop().experienceTeamSort)));
            placeholderArray[11] = new Placeholder("island_members_online", () -> String.join((CharSequence)", ", onlineUsers));
            placeholderArray[12] = new Placeholder("island_members_online_count", () -> String.valueOf(onlineUsers.size()));
            placeholderArray[13] = new Placeholder("island_members_offline", () -> String.join((CharSequence)", ", offlineUsers));
            placeholderArray[14] = new Placeholder("island_members_offline_count", () -> String.valueOf(offlineUsers.size()));
            placeholderArray[15] = new Placeholder("island_members_count", () -> String.valueOf(users.size()));
            ArrayList<Placeholder> placeholderList = new ArrayList<Placeholder>(Arrays.asList(placeholderArray));
            List visitingPlayers = Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getPlayer).filter(Objects::nonNull).filter(player -> island.isInIsland(player.getLocation())).collect(Collectors.toList());
            visitingPlayers.removeIf(player -> onlineUsers.contains(player.getName()));
            placeholderList.add(new Placeholder("island_visitors", () -> visitingPlayers.stream().map(Player::getName).collect(Collectors.joining(", "))));
            placeholderList.add(new Placeholder("island_visitors_amount", () -> String.valueOf(visitingPlayers.size())));
            for (Map.Entry<String, Enhancement<?>> enhancement : IridiumSkyblock.getInstance().getEnhancementList().entrySet()) {
                if (!enhancement.getValue().enabled) continue;
                TeamEnhancement teamEnhancement = IridiumSkyblock.getInstance().getIslandManager().getTeamEnhancement(island, enhancement.getKey());
                placeholderList.add(new Placeholder("island_enhancement_" + enhancement.getKey() + "_active", () -> String.valueOf(teamEnhancement.isActive())));
                placeholderList.add(new Placeholder("island_enhancement_" + enhancement.getKey() + "_level", () -> String.valueOf(teamEnhancement.getLevel())));
                placeholderList.add(new Placeholder("island_enhancement_" + enhancement.getKey() + "_time_hours", () -> String.valueOf(Math.max((int)(teamEnhancement.getRemainingTime() % 60L), 0))));
                placeholderList.add(new Placeholder("island_enhancement_" + enhancement.getKey() + "_time_minutes", () -> String.valueOf(Math.max((int)(teamEnhancement.getRemainingTime() % 3600L / 60L), 0))));
                placeholderList.add(new Placeholder("island_enhancement_" + enhancement.getKey() + "_time_seconds", () -> String.valueOf(Math.max((int)(teamEnhancement.getRemainingTime() / 3600L), 0))));
            }
            for (BankItem bankItem : IridiumSkyblock.getInstance().getBankItemList()) {
                placeholderList.add(new Placeholder("island_bank_" + bankItem.getName().toLowerCase(), () -> this.formatDouble(IridiumSkyblock.getInstance().getTeamManager().getTeamBank(island, bankItem.getName()).getNumber())));
            }
            for (Iterator<Object> iterator : XMaterial.values()) {
                placeholderList.add(new Placeholder("island_" + ((Enum)((Object)iterator)).name().toLowerCase() + "_amount", () -> String.valueOf(IridiumSkyblock.getInstance().getTeamManager().getTeamBlock(island, (XMaterial)((Object)xMaterial)).getAmount())));
            }
            for (Iterator<Object> iterator : XEntityType.values()) {
                placeholderList.add(new Placeholder("island_" + ((Enum)((Object)iterator)).name().toLowerCase() + "_amount", () -> String.valueOf(IridiumSkyblock.getInstance().getTeamManager().getTeamSpawners(island, (XEntityType)((Object)xEntityType)).getAmount())));
            }
            return placeholderList;
        });
    }

    private String formatDouble(double value) {
        return IridiumSkyblock.getInstance().getConfiguration().numberFormatter.format(value);
    }

    private List<Placeholder> initializeDefaultPlaceholders() {
        ArrayList<Placeholder> placeholderList = new ArrayList<Placeholder>(Arrays.asList(new Placeholder("island_name", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_owner", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_create", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_description", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_value", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_level", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_experience", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_experienceToLevelUp", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_experienceForNextLevel", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_value_rank", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_experience_rank", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_members_online", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_members_online_count", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_members_offline", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_members_offline_count", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_members_count", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_visitors", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("island_visitors_amount", IridiumSkyblock.getInstance().getMessages().nullPlaceholder)));
        for (Map.Entry<String, Enhancement<?>> enhancement : IridiumSkyblock.getInstance().getEnhancementList().entrySet()) {
            placeholderList.add(new Placeholder("island_enhancement_" + enhancement.getKey() + "_active", () -> IridiumSkyblock.getInstance().getMessages().nullPlaceholder));
            placeholderList.add(new Placeholder("island_enhancement_" + enhancement.getKey() + "_level", () -> IridiumSkyblock.getInstance().getMessages().nullPlaceholder));
            placeholderList.add(new Placeholder("island_enhancement_" + enhancement.getKey() + "_time_hours", () -> IridiumSkyblock.getInstance().getMessages().nullPlaceholder));
            placeholderList.add(new Placeholder("island_enhancement_" + enhancement.getKey() + "_time_minutes", () -> IridiumSkyblock.getInstance().getMessages().nullPlaceholder));
            placeholderList.add(new Placeholder("island_enhancement_" + enhancement.getKey() + "_time_seconds", () -> IridiumSkyblock.getInstance().getMessages().nullPlaceholder));
        }
        for (BankItem bankItem : IridiumSkyblock.getInstance().getBankItemList()) {
            placeholderList.add(new Placeholder("island_bank_" + bankItem.getName().toLowerCase(), IridiumSkyblock.getInstance().getMessages().nullPlaceholder));
        }
        for (Iterator<Object> iterator : XMaterial.values()) {
            placeholderList.add(new Placeholder("island_" + ((Enum)((Object)iterator)).name().toLowerCase() + "_amount", IridiumSkyblock.getInstance().getMessages().nullPlaceholder));
        }
        for (Iterator<Object> iterator : EntityType.values()) {
            placeholderList.add(new Placeholder("island_" + iterator.name().toLowerCase() + "_amount", IridiumSkyblock.getInstance().getMessages().nullPlaceholder));
        }
        return placeholderList;
    }

    @Override
    public List<Placeholder> getPlaceholders(Optional<Island> optional) {
        return optional.isPresent() ? this.getPlaceholders(optional.get()) : this.defaultPlaceholders;
    }
}

