/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.placeholders;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.database.User;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PlaceholderBuilder;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.TemporaryCache;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.UserRank;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class UserPlaceholderBuilder
implements PlaceholderBuilder<User> {
    private final TemporaryCache<User, List<Placeholder>> cache = new TemporaryCache();
    private final List<Placeholder> defaultPlaceholders;

    public UserPlaceholderBuilder() {
        this.defaultPlaceholders = Arrays.asList(new Placeholder("player_rank", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("player_name", IridiumSkyblock.getInstance().getMessages().nullPlaceholder), new Placeholder("player_join", IridiumSkyblock.getInstance().getMessages().nullPlaceholder));
    }

    @Override
    public List<Placeholder> getPlaceholders(User user) {
        return this.cache.get(user, Duration.ofSeconds(1L), () -> Arrays.asList(new Placeholder("player_rank", IridiumSkyblock.getInstance().getUserRanks().getOrDefault((Object)Integer.valueOf((int)user.getUserRank()), (UserRank)new UserRank((String)IridiumSkyblock.getInstance().getMessages().nullPlaceholder, null)).name), new Placeholder("player_name", user.getName()), new Placeholder("player_join", user.getJoinTime().format(DateTimeFormatter.ofPattern(IridiumSkyblock.getInstance().getConfiguration().dateTimeFormat)))));
    }

    @Override
    public List<Placeholder> getPlaceholders(Optional<User> optional) {
        return optional.isPresent() ? this.getPlaceholders(optional.get()) : this.defaultPlaceholders;
    }
}

