/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.schematics;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.dependencies.jnbt.ByteTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.CompoundTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.IntArrayTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.IntTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.ListTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.StringTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.Tag;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import com.iridium.iridiumskyblock.schematics.Coordinate;
import com.iridium.iridiumskyblock.schematics.SchematicData;
import com.iridium.iridiumskyblock.schematics.SchematicPaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SchematicAsync
implements SchematicPaster {
    private static final Map<File, SchematicData> schematicCache = new HashMap<File, SchematicData>();

    @Override
    public void paste(File file, final Location location, final Boolean ignoreAirBlock, final CompletableFuture<Void> completableFuture) {
        final SchematicData schematicData = this.getSchematicData(file);
        final ListIterator<Coordinate> coordinates = this.getCoordinates(schematicData);
        int delay = IridiumSkyblock.getInstance().getConfiguration().pasterDelayInTick;
        final short length = schematicData.length;
        final short width = schematicData.width;
        short height = schematicData.height;
        int newLength = (int)((double)length / 2.0);
        int newWidth = (int)((double)width / 2.0);
        int newHeight = (int)((double)height / 2.0);
        location.subtract((double)newWidth, (double)newHeight, (double)newLength);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                int remaining = IridiumSkyblock.getInstance().getConfiguration().pasterLimitPerTick;
                while (remaining != 0 && coordinates.hasNext()) {
                    Coordinate coordinate = (Coordinate)coordinates.next();
                    int x = coordinate.x;
                    int y = coordinate.y;
                    int z = coordinate.z;
                    int index = y * width * length + z * width + x;
                    Block block = new Location(location.getWorld(), (double)x + location.getX(), (double)y + location.getY(), (double)z + location.getZ()).getBlock();
                    for (String blockData : schematicData.palette.keySet()) {
                        BlockData data;
                        int i = SchematicData.getChildTag(schematicData.palette, blockData, IntTag.class).getValue();
                        if (schematicData.blockdata[index] != i || (data = Bukkit.createBlockData((String)blockData)).getMaterial() == Material.AIR && ignoreAirBlock.booleanValue()) continue;
                        block.setBlockData(data, false);
                        --remaining;
                    }
                }
                if (!coordinates.hasNext()) {
                    for (Tag tag : schematicData.tileEntities) {
                        if (!(tag instanceof CompoundTag)) continue;
                        CompoundTag t = (CompoundTag)tag;
                        Object tags = t.getValue();
                        int[] pos = SchematicData.getChildTag((Map<String, Tag>)tags, "Pos", IntArrayTag.class).getValue();
                        int x = pos[0];
                        int y = pos[1];
                        int z = pos[2];
                        Block block = new Location(location.getWorld(), (double)x + location.getX(), (double)y + location.getY(), (double)z + location.getZ()).getBlock();
                        String id = SchematicData.getChildTag((Map<String, Tag>)tags, "Id", StringTag.class).getValue().toLowerCase().replace("minecraft:", "");
                        if (!id.equalsIgnoreCase("chest")) continue;
                        Object items = SchematicData.getChildTag((Map<String, Tag>)tags, "Items", ListTag.class).getValue();
                        if (!(block.getState() instanceof Chest)) continue;
                        Chest chest = (Chest)block.getState();
                        Iterator iterator = items.iterator();
                        while (iterator.hasNext()) {
                            XMaterial material;
                            ItemStack itemStack;
                            Tag item = (Tag)iterator.next();
                            if (!(item instanceof CompoundTag)) continue;
                            Object itemtag = ((CompoundTag)item).getValue();
                            byte slot = SchematicData.getChildTag((Map<String, Tag>)itemtag, "Slot", ByteTag.class).getValue();
                            String name = SchematicData.getChildTag((Map<String, Tag>)itemtag, "id", StringTag.class).getValue().toLowerCase().replace("minecraft:", "").replace("reeds", "sugar_cane");
                            Byte amount = SchematicData.getChildTag((Map<String, Tag>)itemtag, "Count", ByteTag.class).getValue();
                            Optional<XMaterial> optionalXMaterial = XMaterial.matchXMaterial(name.toUpperCase());
                            if (!optionalXMaterial.isPresent() || (itemStack = (material = optionalXMaterial.get()).parseItem()) == null) continue;
                            itemStack.setAmount((int)amount.byteValue());
                            chest.getBlockInventory().setItem((int)slot, itemStack);
                        }
                    }
                    completableFuture.complete(null);
                    this.cancel();
                }
            }
        };
        runnable.runTaskTimer((Plugin)IridiumSkyblock.getInstance(), (long)delay, (long)delay);
    }

    private SchematicData getSchematicData(File file) {
        try {
            SchematicData schematicData = schematicCache.getOrDefault(file, null);
            if (schematicData == null) {
                schematicData = SchematicData.loadSchematic(file);
            }
            schematicCache.put(file, schematicData);
            return schematicData;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ListIterator<Coordinate> getCoordinates(SchematicData schematicData) {
        int length = schematicData.length;
        int width = schematicData.width;
        int height = schematicData.height;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    coordinates.add(new Coordinate(x, y, z));
                }
            }
        }
        return coordinates.listIterator();
    }

    @Override
    public void clearCache() {
        schematicCache.clear();
    }
}

