/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.database;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class User
extends IridiumUser<Island> {
    private Optional<Island> currentIsland = Optional.empty();

    public User(UUID uuid, String name) {
        this.setUuid(uuid);
        this.setName(name);
        this.setJoinTime(LocalDateTime.now());
    }

    public Optional<Island> getIsland() {
        return IridiumSkyblock.getInstance().getTeamManager().getTeamViaID(this.getTeamID());
    }

    public Optional<Island> getCurrentIsland() {
        Player player = this.getPlayer();
        if (player == null) {
            return Optional.empty();
        }
        if (this.currentIsland.isPresent() && this.currentIsland.get().isInIsland(player.getLocation())) {
            return this.currentIsland;
        }
        this.setCurrentIsland(IridiumSkyblock.getInstance().getTeamManager().getTeamViaLocation(player.getLocation()));
        return this.currentIsland;
    }

    public Optional<Island> getCurrentIsland(Location location) {
        Player player = this.getPlayer();
        if (player == null) {
            return Optional.empty();
        }
        if (this.currentIsland.isPresent() && this.currentIsland.get().isInIsland(location)) {
            return this.currentIsland;
        }
        Optional<Island> islandOptional = IridiumSkyblock.getInstance().getIslandManager().getTeamViaLocation(location);
        islandOptional.ifPresent(island -> {
            if (island.isInIsland(player.getLocation())) {
                this.setCurrentIsland(islandOptional);
            }
        });
        return islandOptional;
    }

    @Generated
    public User() {
    }

    @Generated
    public void setCurrentIsland(Optional<Island> currentIsland) {
        this.currentIsland = currentIsland;
    }
}

