/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumcore;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Entity;

public class CooldownProvider<T> {
    private final Map<Object, Duration> cooldownTimes = new HashMap<Object, Duration>();
    private final Duration duration;

    public CooldownProvider(Duration duration) {
        this.duration = duration;
    }

    public boolean isOnCooldown(Object t) {
        if (t instanceof Entity) {
            return this.isOnCooldown(((Entity)t).getUniqueId());
        }
        return this.cooldownTimes.containsKey(t) && this.cooldownTimes.get(t).toMillis() > System.currentTimeMillis();
    }

    public Duration getRemainingTime(Object t) {
        if (t instanceof Entity) {
            return this.getRemainingTime(((Entity)t).getUniqueId());
        }
        if (!this.isOnCooldown(t)) {
            return Duration.ZERO;
        }
        return this.cooldownTimes.get(t).minusMillis(System.currentTimeMillis());
    }

    public void applyCooldown(Object t) {
        if (t instanceof Entity) {
            this.applyCooldown(((Entity)t).getUniqueId());
            return;
        }
        this.cooldownTimes.put(t, this.duration.plusMillis(System.currentTimeMillis()));
    }
}

