/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumcore.utils;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.Background;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.util.List;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryUtils {
    public static int getAmount(Inventory inventory, XMaterial material) {
        int total = 0;
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !material.isSimilar(item)) continue;
            total += item.getAmount();
        }
        return total;
    }

    public static void removeAmount(Inventory inventory, XMaterial material, int amount) {
        int removed = 0;
        int index = 0;
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack == null) {
                ++index;
                continue;
            }
            if (removed >= amount) break;
            if (material.isSimilar(itemStack)) {
                if (removed + itemStack.getAmount() <= amount) {
                    removed += itemStack.getAmount();
                    inventory.setItem(index, null);
                } else {
                    itemStack.setAmount(itemStack.getAmount() - (amount - removed));
                    removed += amount;
                }
            }
            ++index;
        }
    }

    public static boolean hasEmptySlot(Inventory inventory) {
        return inventory.firstEmpty() != -1;
    }

    public static void fillInventory(Inventory inventory, Background background) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            inventory.setItem(i, ItemStackUtils.makeItem(background.filler));
        }
        if (background.items == null) {
            return;
        }
        for (int slot : background.items.keySet()) {
            if (slot >= inventory.getSize()) continue;
            inventory.setItem(slot, ItemStackUtils.makeItem(background.items.get(slot)));
        }
    }

    public static void fillInventory(Inventory inventory, Background background, List<Placeholder> placeholders) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            inventory.setItem(i, ItemStackUtils.makeItem(background.filler, placeholders));
        }
        for (int slot : background.items.keySet()) {
            if (slot >= inventory.getSize()) continue;
            inventory.setItem(slot, ItemStackUtils.makeItem(background.items.get(slot), placeholders));
        }
    }
}

