/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumcore.utils;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.IridiumCore;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.Item;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.SkinUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.nbtapi.NBT;
import com.iridium.iridiumskyblock.dependencies.nbtapi.NBTItem;
import com.iridium.iridiumskyblock.dependencies.nbtapi.iface.ReadWriteNBT;
import com.iridium.iridiumskyblock.dependencies.nbtapi.utils.DataFixerUtil;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import com.iridium.iridiumskyblock.dependencies.xseries.profiles.builder.XSkull;
import com.iridium.iridiumskyblock.dependencies.xseries.profiles.objects.Profileable;
import com.iridium.iridiumskyblock.dependencies.xseries.reflection.XReflection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemStackUtils {
    private static final boolean supports = XReflection.supports(16);
    private static final HashMap<String, UUID> uuidMap = new HashMap();
    private static final Pattern username = Pattern.compile("[A-Za-z0-9_]{1,16}");

    public static ItemStack makeItem(XMaterial material, int amount, String name, List<String> lore) {
        ItemStack itemStack = material.parseItem();
        if (itemStack == null) {
            return new ItemStack(Material.AIR);
        }
        itemStack.setAmount(amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            itemMeta.setLore(StringUtils.color(lore));
            itemMeta.setDisplayName(StringUtils.color(name));
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public static ItemStack makeItem(Item item, List<Placeholder> placeholders) {
        ItemStack itemStack = ItemStackUtils.makeItem(item.material, item.amount, StringUtils.processMultiplePlaceholders(item.displayName, placeholders), StringUtils.processMultiplePlaceholders(item.lore, placeholders));
        if (item.material == XMaterial.PLAYER_HEAD && item.skullData != null && !item.skullData.isEmpty() && !IridiumCore.isTesting()) {
            String skullData = StringUtils.processMultiplePlaceholders(item.skullData, placeholders);
            if (username.matcher(skullData).matches()) {
                skullData = SkinUtils.getHeadData(SkinUtils.getUUID(skullData));
            }
            itemStack = XSkull.of(itemStack).profile(Profileable.detect(skullData)).apply();
        }
        return itemStack;
    }

    public static ItemStack makeItem(Item item) {
        return ItemStackUtils.makeItem(item, Collections.emptyList());
    }

    public static String serialize(ItemStack itemStack) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream bukkitObjectOutputStream = new BukkitObjectOutputStream((OutputStream)byteArrayOutputStream);
            bukkitObjectOutputStream.writeObject((Object)itemStack);
            bukkitObjectOutputStream.flush();
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception e) {
            return "";
        }
    }

    public static ItemStack deserialize(String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(string));
            BukkitObjectInputStream bukkitObjectInputStream = new BukkitObjectInputStream((InputStream)byteArrayInputStream);
            return (ItemStack)bukkitObjectInputStream.readObject();
        }
        catch (Exception exception) {
            return XMaterial.AIR.parseItem();
        }
    }

    private static ItemStack setHeadData(String headData, ItemStack itemStack) {
        if (IridiumCore.isTesting()) {
            return itemStack;
        }
        if (headData == null) {
            return itemStack;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        nbtItem.setInteger("Count", itemStack.getAmount());
        nbtItem.setString("id", "player_head");
        ReadWriteNBT skull = NBT.createNBTObject();
        if (supports) {
            skull.setUUID("Id", ItemStackUtils.getHeadDataUUID(headData));
        } else {
            skull.setString("Id", ItemStackUtils.getHeadDataUUID(headData).toString());
        }
        ReadWriteNBT texture = skull.getOrCreateCompound("Properties").getCompoundList("textures").addCompound();
        texture.setString("Value", headData);
        nbtItem.getOrCreateCompound("tag").getOrCreateCompound("SkullOwner").mergeCompound(skull);
        try {
            return NBT.itemStackFromNBT(DataFixerUtil.fixUpItemData(nbtItem, 3700, DataFixerUtil.getCurrentVersion()));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static ItemStack setModel(int model, ItemStack itemStack) {
        if (IridiumCore.isTesting()) {
            return itemStack;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        itemMeta.setCustomModelData(Integer.valueOf(model));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private static UUID getHeadDataUUID(String headData) {
        if (!uuidMap.containsKey(headData)) {
            uuidMap.put(headData, UUID.randomUUID());
        }
        return uuidMap.get(headData);
    }
}

