/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import lombok.Generated;

public class TemporaryCache<Key, Value> {
    private final Map<Key, CachedValue<Value>> cache = new ConcurrentHashMap<Key, CachedValue<Value>>();

    public Value get(Key key, Duration duration, Supplier<Value> valueSupplier) {
        CachedValue<Value> cachedValue = this.cache.get(key);
        if (cachedValue != null && !cachedValue.hasExpired()) {
            return cachedValue.getValue();
        }
        Value value = valueSupplier.get();
        this.cache.put(key, new CachedValue<Value>(value, duration));
        return value;
    }

    private static class CachedValue<T> {
        private final T value;
        private final Instant expiryTime;

        public CachedValue(T value, Duration duration) {
            this.value = value;
            this.expiryTime = Instant.now().plus(duration);
        }

        public boolean hasExpired() {
            return Instant.now().isAfter(this.expiryTime);
        }

        @Generated
        public T getValue() {
            return this.value;
        }
    }
}

