/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Rank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.List;
import lombok.Generated;
import org.bukkit.entity.Player;

public class CreateCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public CreateCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (iridiumTeams.getTeamManager().getTeamViaID(((IridiumUser)user).getTeamID()).isPresent()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().alreadyHaveTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (args.length < 1) {
            if (iridiumTeams.getConfiguration().createRequiresName) {
                player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return false;
            }
            iridiumTeams.getTeamManager().createTeam(player, null).thenAccept(team -> {
                if (team == null) {
                    return;
                }
                user.setUserRank(Rank.OWNER.getId());
                player.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamCreated.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                this.getCooldownProvider().applyCooldown(player);
            });
            return false;
        }
        String teamName = String.join((CharSequence)" ", args);
        if (teamName.length() < iridiumTeams.getConfiguration().minTeamNameLength) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamNameTooShort.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%min_length%", String.valueOf(iridiumTeams.getConfiguration().minTeamNameLength))));
            return false;
        }
        if (teamName.length() > iridiumTeams.getConfiguration().maxTeamNameLength) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamNameTooLong.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%max_length%", String.valueOf(iridiumTeams.getConfiguration().maxTeamNameLength))));
            return false;
        }
        if (iridiumTeams.getTeamManager().getTeamViaName(teamName).isPresent()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamNameAlreadyExists.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        iridiumTeams.getTeamManager().createTeam(player, teamName).thenAccept(team -> {
            if (team == null) {
                return;
            }
            user.setUserRank(Rank.OWNER.getId());
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamCreated.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            this.getCooldownProvider().applyCooldown(player);
        });
        return false;
    }

    @Generated
    public CreateCommand() {
    }
}

