/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Rank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PromoteCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public PromoteCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length != 1) {
            player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        OfflinePlayer targetPlayer = Bukkit.getServer().getOfflinePlayer(args[0]);
        U targetUser = iridiumTeams.getUserManager().getUser(targetPlayer);
        if (((IridiumUser)targetUser).getTeamID() != ((Team)team).getId()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().userNotInYourTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        int nextRank = ((IridiumUser)targetUser).getUserRank() + 1;
        if (!this.DoesRankExist(nextRank, iridiumTeams) || this.IsHigherRank(targetUser, user) || !iridiumTeams.getTeamManager().getTeamPermission(team, user, PermissionType.PROMOTE)) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().cannotPromoteUser.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        ((IridiumUser)targetUser).setUserRank(nextRank);
        for (IridiumUser member : iridiumTeams.getTeamManager().getTeamMembers(team)) {
            Player teamMember = Bukkit.getPlayer((UUID)member.getUuid());
            if (teamMember == null) continue;
            if (teamMember.equals(player)) {
                teamMember.sendMessage(StringUtils.color(iridiumTeams.getMessages().promotedPlayer.replace("%player%", ((IridiumUser)targetUser).getName()).replace("%rank%", iridiumTeams.getUserRanks().get((Object)Integer.valueOf((int)nextRank)).name).replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                continue;
            }
            teamMember.sendMessage(StringUtils.color(iridiumTeams.getMessages().userPromotedPlayer.replace("%promoter%", player.getName()).replace("%player%", ((IridiumUser)targetUser).getName()).replace("%rank%", iridiumTeams.getUserRanks().get((Object)Integer.valueOf((int)nextRank)).name).replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
    }

    private boolean DoesRankExist(int rank, IridiumTeams<T, U> iridiumTeams) {
        if (rank < 1) {
            return false;
        }
        return iridiumTeams.getUserRanks().containsKey(rank);
    }

    private boolean IsHigherRank(U target, U user) {
        if (((IridiumUser)target).getUserRank() == Rank.OWNER.getId()) {
            return true;
        }
        if (((IridiumUser)user).getUserRank() == Rank.OWNER.getId()) {
            return false;
        }
        if (((IridiumUser)user).isBypassing()) {
            return false;
        }
        return ((IridiumUser)target).getUserRank() + 1 >= ((IridiumUser)user).getUserRank();
    }

    @Generated
    public PromoteCommand() {
    }
}

