/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Rank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.ConfirmationGUI;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TransferCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public TransferCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length != 1) {
            player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (((IridiumUser)user).getUserRank() != Rank.OWNER.getId() && !((IridiumUser)user).isBypassing()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().mustBeOwnerToTransfer.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        Player targetPlayer = Bukkit.getServer().getPlayer(args[0]);
        if (targetPlayer == null) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().notAPlayer.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        Object targetUser = iridiumTeams.getUserManager().getUser((OfflinePlayer)targetPlayer);
        if (((IridiumUser)targetUser).getTeamID() != ((Team)team).getId()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().userNotInYourTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (targetPlayer.getUniqueId().equals(player.getUniqueId()) && !((IridiumUser)user).isBypassing()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().cannotTransferToYourself.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        player.openInventory(new ConfirmationGUI<T, U>(() -> {
            targetUser.setUserRank(Rank.OWNER.getId());
            iridiumTeams.getTeamManager().getTeamMembers((Team)team).forEach(user1 -> {
                Player p;
                if (user1.getUserRank() == Rank.OWNER.getId() && user1 != targetUser) {
                    user1.setUserRank(iridiumTeams.getUserRanks().keySet().stream().max(Integer::compareTo).orElse(1));
                }
                if ((p = user1.getPlayer()) != null) {
                    p.sendMessage(StringUtils.color(iridiumTeams.getMessages().ownershipTransferred.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%old_owner%", user.getName()).replace("%new_owner%", targetUser.getName())));
                }
            });
            this.getCooldownProvider().applyCooldown(player);
        }, iridiumTeams).getInventory());
        return false;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
    }

    @Generated
    public TransferCommand() {
    }
}

